/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.test;

import com.swiftmq.filetransfer.Filetransfer;
import java.io.File;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class FileReceiverSynchron {
    static Connection connection = null;
    static File outDir = null;
    static Filetransfer filetransfer = null;

    private static void transfer(String link) throws Exception {
        System.out.println("Transferring: " + link);
        filetransfer.withLink(link).withOriginalFilename(true).withOutputDirectory(outDir).withPassword("Moin!").receive((filename, chunksTransferred, fileSize, bytesTransferred, transferredPercent) -> System.out.println("  " + filename + ": " + chunksTransferred + " chunks, " + bytesTransferred + " of " + fileSize + " transferred (" + transferredPercent + "%)")).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("Usage: FileReceiverSynchron <smqp-url> <connection-factory> <link-input-dest> <output-dir>");
            System.exit(-1);
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.swiftmq.jndi.InitialContextFactoryImpl");
            env.put("java.naming.provider.url", args[0]);
            InitialContext ctx = new InitialContext(env);
            ConnectionFactory cf = (ConnectionFactory)ctx.lookup(args[1]);
            Destination linkInputDest = (Destination)ctx.lookup(args[2]);
            ctx.close();
            connection = cf.createConnection();
            connection.start();
            outDir = new File(args[3]);
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            filetransfer = Filetransfer.create(connection, "router1", "test").withDigestType("MD5");
            Session session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer(linkInputDest);
            TextMessage msg = null;
            while ((msg = (TextMessage)consumer.receive(30000L)) != null) {
                String link = msg.getText();
                FileReceiverSynchron.transfer(link);
            }
            filetransfer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                connection.close();
            }
            catch (JMSException jMSException) {}
        }
    }
}

