/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.test;

import com.swiftmq.filetransfer.Filetransfer;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;

public class SendDirConcurrently {
    static Connection connection = null;
    static Queue linkInputQueue = null;
    static String routerName = null;
    static String cacheName = null;

    private static void transfer(File file) throws Exception {
        if (file.length() == 0L) {
            return;
        }
        System.out.println("Transferring: " + file.getName());
        Filetransfer filetransfer = Filetransfer.create(connection, routerName, cacheName).withDigestType("MD5");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("orderid", new Random().nextInt());
        props.put("customerid", new Random().nextInt());
        boolean isPrivate = file.getName().contains("_eval");
        String link = filetransfer.withFile(file).withFileIsPrivate(isPrivate).withPassword("Cheers").withProperties(props).send((filename, chunksTransferred, fileSize, bytesTransferred, transferredPercent) -> System.out.println("  " + filename + ": " + chunksTransferred + " chunks, " + bytesTransferred + " of " + fileSize + " transferred (" + transferredPercent + "%)"));
        Session session = connection.createSession(false, 1);
        MessageProducer linkSender = session.createProducer((Destination)linkInputQueue);
        linkSender.send((Message)session.createTextMessage(link));
        session.close();
        filetransfer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println("Usage: SendDirConcurrently <smqp-url> <connection-factory> <filename> <routerName> <cacheName>");
            System.exit(-1);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        try {
            File[] files;
            File file = new File(args[2]);
            if (!file.exists()) {
                throw new Exception("File '" + args[2] + "' does not exists!");
            }
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.swiftmq.jndi.InitialContextFactoryImpl");
            env.put("java.naming.provider.url", args[0]);
            InitialContext ctx = new InitialContext(env);
            ConnectionFactory cf = (ConnectionFactory)ctx.lookup(args[1]);
            linkInputQueue = (Queue)ctx.lookup("link-input");
            ctx.close();
            routerName = args[3];
            cacheName = args[4];
            connection = cf.createConnection();
            connection.start();
            if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
                CountDownLatch countDownLatch = new CountDownLatch(files.length);
                for (File file1 : files) {
                    if (!file1.isDirectory()) {
                        File f = file1;
                        executorService.execute(() -> {
                            try {
                                SendDirConcurrently.transfer(f);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            countDownLatch.countDown();
                        });
                        continue;
                    }
                    countDownLatch.countDown();
                }
                countDownLatch.await();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            executorService.shutdown();
            try {
                connection.close();
            }
            catch (JMSException jMSException) {}
        }
    }
}

