/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.test;

import com.swiftmq.filetransfer.Filetransfer;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;

public class SendFile {
    static Filetransfer filetransfer = null;
    static Session session = null;
    static MessageProducer linkSender = null;

    private static void transfer(File file) throws Exception {
        if (file.length() == 0L) {
            return;
        }
        System.out.println("Transferring: " + file.getName());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("path", file.getPath());
        props.put("absolutepath", file.getAbsolutePath());
        props.put("canonicalpath", file.getCanonicalPath());
        String link = filetransfer.withFile(file).withProperties(props).withPassword("Moin!").send((filename, chunksTransferred, fileSize, bytesTransferred, transferredPercent) -> System.out.println("  " + filename + ": " + chunksTransferred + " chunks, " + bytesTransferred + " of " + fileSize + " transferred (" + transferredPercent + "%)"));
        linkSender.send((Message)session.createTextMessage(link));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println("Usage: SendDirConcurrently <smqp-url> <connection-factory> <filename> <routerName> <cacheName>");
            System.exit(-1);
        }
        Connection connection = null;
        try {
            File file = new File(args[2]);
            if (!file.exists()) {
                throw new Exception("File '" + args[2] + "' does not exists!");
            }
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.swiftmq.jndi.InitialContextFactoryImpl");
            env.put("java.naming.provider.url", args[0]);
            InitialContext ctx = new InitialContext(env);
            ConnectionFactory cf = (ConnectionFactory)ctx.lookup(args[1]);
            Queue linkInputQueue = (Queue)ctx.lookup("link-input");
            ctx.close();
            connection = cf.createConnection();
            session = connection.createSession(false, 1);
            linkSender = session.createProducer((Destination)linkInputQueue);
            connection.start();
            filetransfer = Filetransfer.create(connection, args[3], args[4]).withDigestType("MD5");
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null && files.length > 0) {
                    for (File file1 : files) {
                        if (file1.isDirectory()) continue;
                        SendFile.transfer(file1);
                    }
                }
            } else {
                SendFile.transfer(file);
            }
            filetransfer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                connection.close();
            }
            catch (JMSException jMSException) {}
        }
    }
}

