/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.v940;

import com.swiftmq.filetransfer.Util;

public class LinkBuilder {
    String routerName = null;
    String cacheName = null;
    String fileKey = null;
    String digestType = null;
    byte[] digest = null;

    public LinkBuilder(String routerName, String cacheName, String fileKey, String digestType, byte[] digest) {
        this.routerName = routerName;
        this.cacheName = cacheName;
        this.fileKey = fileKey;
        this.digestType = digestType;
        this.digest = digest;
    }

    public LinkBuilder() {
    }

    public LinkBuilder routerName(String routerName) {
        this.routerName = routerName;
        return this;
    }

    public LinkBuilder cacheName(String cacheName) {
        this.cacheName = cacheName;
        return this;
    }

    public LinkBuilder fileKey(String fileKey) {
        this.fileKey = fileKey;
        return this;
    }

    public LinkBuilder digestType(String digestType) {
        this.digestType = digestType;
        return this;
    }

    public LinkBuilder digest(byte[] digest) {
        this.digest = digest;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.routerName != null) {
            sb.append("router=").append(this.routerName);
        }
        if (this.cacheName != null) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("cache=").append(this.cacheName);
        }
        if (this.fileKey != null) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("file=").append(this.fileKey);
        }
        if (this.digest != null) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("digesttype=").append(this.digestType).append(';');
            sb.append("digest=").append(Util.byteArrayToHexString(this.digest));
        }
        return sb.toString();
    }
}

