/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.v941;

import com.swiftmq.filetransfer.Filetransfer;
import com.swiftmq.filetransfer.FiletransferException;
import com.swiftmq.filetransfer.JMSAccessorHolder;
import com.swiftmq.filetransfer.ProgressListener;
import com.swiftmq.filetransfer.Util;
import com.swiftmq.filetransfer.protocol.MessageBasedFactory;
import com.swiftmq.filetransfer.protocol.v941.FileChunkReply;
import com.swiftmq.filetransfer.protocol.v941.FileChunkRequest;
import com.swiftmq.filetransfer.protocol.v941.FileConsumeReply;
import com.swiftmq.filetransfer.protocol.v941.FileConsumeRequest;
import com.swiftmq.filetransfer.protocol.v941.FileDeleteReply;
import com.swiftmq.filetransfer.protocol.v941.FileDeleteRequest;
import com.swiftmq.filetransfer.protocol.v941.FilePublishReply;
import com.swiftmq.filetransfer.protocol.v941.FilePublishRequest;
import com.swiftmq.filetransfer.protocol.v941.FileQueryPropsReply;
import com.swiftmq.filetransfer.protocol.v941.FileQueryPropsRequest;
import com.swiftmq.filetransfer.protocol.v941.FileQueryReply;
import com.swiftmq.filetransfer.protocol.v941.FileQueryRequest;
import com.swiftmq.filetransfer.protocol.v941.ProtocolFactory;
import com.swiftmq.filetransfer.protocol.v941.SessionCloseRequest;
import com.swiftmq.filetransfer.v940.LinkBuilder;
import com.swiftmq.filetransfer.v940.LinkParser;
import com.swiftmq.tools.requestreply.RequestRegistry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;

public class FiletransferImpl
extends Filetransfer {
    private static final String DEFAULT_DIGEST = "MD5";
    JMSAccessorHolder accessorHolder = null;
    File file = null;
    String filename = null;
    String link = null;
    long expiration = 0L;
    int deleteAfterNumberDownloads = 0;
    String password = null;
    String passwordHexDigest = null;
    boolean fileIsPrivate = false;
    boolean useOriginalFilename = true;
    File outputDir = null;
    int chunkLength = 0;
    String digestType = "MD5";
    int replyInterval = 10;
    Map<String, Object> properties = null;
    String selector = null;
    MessageBasedFactory messageBasedFactory = new ProtocolFactory();
    boolean closed = false;

    public FiletransferImpl(JMSAccessorHolder accessorHolder) {
        this.accessorHolder = accessorHolder;
    }

    private void checkState() {
        if (this.closed) {
            throw new IllegalStateException("This object has already been closed.");
        }
    }

    @Override
    public Filetransfer withFile(File file) {
        this.checkState();
        this.file = file;
        return this;
    }

    @Override
    public Filetransfer withFilename(String filename) {
        this.checkState();
        this.filename = filename;
        return this;
    }

    @Override
    public Filetransfer withLink(String link) {
        this.checkState();
        this.link = link;
        return this;
    }

    @Override
    public Filetransfer withDigestType(String digestType) {
        this.checkState();
        this.digestType = digestType;
        return this;
    }

    @Override
    public Filetransfer withDeleteAfterNumberDownloads(int deleteAfterNumberDownloads) {
        this.checkState();
        this.deleteAfterNumberDownloads = deleteAfterNumberDownloads;
        return this;
    }

    @Override
    public Filetransfer withExpiration(long expiration) {
        this.checkState();
        this.expiration = expiration;
        return this;
    }

    @Override
    public Filetransfer withPassword(String password) {
        this.checkState();
        this.password = password;
        return this;
    }

    @Override
    public Filetransfer withPasswordHexDigest(String passwordHexDigest) {
        this.checkState();
        this.passwordHexDigest = passwordHexDigest;
        return this;
    }

    @Override
    public Filetransfer withFileIsPrivate(boolean fileIsPrivate) {
        this.checkState();
        this.fileIsPrivate = fileIsPrivate;
        return this;
    }

    @Override
    public Filetransfer withOutputDirectory(File outputDir) {
        this.checkState();
        this.outputDir = outputDir;
        return this;
    }

    @Override
    public Filetransfer withOriginalFilename(boolean withOriginalFilename) {
        this.checkState();
        this.useOriginalFilename = withOriginalFilename;
        return this;
    }

    @Override
    public Filetransfer withProperties(Map<String, Object> properties) {
        this.checkState();
        this.properties = properties;
        return this;
    }

    @Override
    public Filetransfer withSelector(String selector) {
        this.checkState();
        this.selector = selector;
        return this;
    }

    @Override
    public Filetransfer withReplyInterval(int replyInterval) {
        this.checkState();
        this.replyInterval = replyInterval;
        return this;
    }

    @Override
    public String send() throws Exception {
        return this.send(null);
    }

    @Override
    public String send(ProgressListener progressListener) throws FiletransferException, JMSException, IOException, NoSuchAlgorithmException {
        FilePublishReply reply;
        this.checkState();
        if (this.file == null) {
            throw new NullPointerException("File is not specified");
        }
        if (!this.file.exists()) {
            throw new FileNotFoundException("File not found");
        }
        if (this.file.isDirectory()) {
            throw new FiletransferException("File to transfer is a directory");
        }
        long fileLength = this.file.length();
        if (fileLength == 0L) {
            throw new FiletransferException("File to transfer is empty");
        }
        if (this.passwordHexDigest == null && this.password != null) {
            byte[] pwdigest = MessageDigest.getInstance(this.digestType).digest(this.password.getBytes());
            this.passwordHexDigest = Util.byteArrayToHexString(pwdigest);
        }
        if (!(reply = (FilePublishReply)FiletransferImpl.request(new FilePublishRequest(this.accessorHolder.replyQueue.getQueueName(), this.filename == null ? this.file.getName() : this.filename, this.accessorHolder.username, fileLength, this.expiration, this.deleteAfterNumberDownloads, this.digestType, this.passwordHexDigest, this.fileIsPrivate), this.accessorHolder, this.messageBasedFactory, this.properties)).isOk()) {
            throw new FiletransferException(reply.getException());
        }
        String filename = this.file.getName();
        this.chunkLength = reply.getChunkLength();
        DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(this.file), MessageDigest.getInstance(this.digestType));
        BufferedInputStream in = new BufferedInputStream(digestInputStream);
        byte[] chunk = new byte[this.chunkLength];
        int len = 0;
        long cumulatedLen = 0L;
        int chunkNo = 1;
        while ((len = in.read(chunk, 0, Math.min(this.chunkLength, (int)(fileLength - cumulatedLen)))) != -1) {
            this.link = null;
            boolean last = (cumulatedLen += (long)len) == fileLength;
            boolean replyRequired = chunkNo % this.replyInterval == 0 || last;
            FileChunkReply chunkReply = (FileChunkReply)FiletransferImpl.request(new FileChunkRequest(replyRequired, chunkNo, last, chunk, len), this.accessorHolder, this.messageBasedFactory);
            if (replyRequired) {
                if (chunkReply.isOk()) {
                    if (chunkReply.getChunkNo() != chunkNo) {
                        throw new FiletransferException("Chunks no mismatch, sent: " + chunkNo + ", received: " + chunkReply.getChunkNo());
                    }
                    if (last) {
                        String linkString = chunkReply.getLink();
                        if (linkString == null) {
                            throw new FiletransferException("No link returned on the last chunk");
                        }
                        this.link = linkString;
                    }
                } else {
                    throw new FiletransferException(reply.getException());
                }
            }
            if (progressListener != null && replyRequired) {
                progressListener.progress(filename, chunkNo, fileLength, cumulatedLen, (int)(cumulatedLen * 100L / fileLength));
            }
            ++chunkNo;
            if (!last) continue;
            break;
        }
        byte[] cacheDigest = new LinkParser(this.link).getDigest();
        byte[] localDigest = digestInputStream.getMessageDigest().digest();
        if (cacheDigest == null || localDigest == null || !Arrays.equals(localDigest, cacheDigest)) {
            throw new FiletransferException("Cache digest is not equal to local digest");
        }
        return this.link;
    }

    @Override
    public Filetransfer receive() throws FiletransferException, JMSException, IOException, NoSuchAlgorithmException {
        return this.receive(null);
    }

    @Override
    public Filetransfer receive(ProgressListener progressListener) throws FiletransferException, JMSException, IOException, NoSuchAlgorithmException {
        FileConsumeReply reply;
        this.checkState();
        if (!this.useOriginalFilename && this.file == null) {
            throw new NullPointerException("File is not specified");
        }
        if (this.useOriginalFilename && this.outputDir == null) {
            throw new NullPointerException("Output directory is not specified");
        }
        if (this.link == null) {
            throw new NullPointerException("Link is not specified");
        }
        LinkParser linkParser = new LinkParser(this.link);
        String pwdHexDigest = null;
        if (this.password != null) {
            byte[] pwdigest = MessageDigest.getInstance(linkParser.getDigestType()).digest(this.password.getBytes());
            pwdHexDigest = Util.byteArrayToHexString(pwdigest);
        }
        if (!(reply = (FileConsumeReply)FiletransferImpl.request(new FileConsumeRequest(this.accessorHolder.replyQueue.getQueueName(), this.link, pwdHexDigest, this.replyInterval), this.accessorHolder, this.messageBasedFactory, null)).isOk()) {
            throw new FiletransferException(reply.getException());
        }
        if (this.useOriginalFilename) {
            this.file = new File(this.outputDir, reply.getFilename());
        }
        if (this.file.exists()) {
            this.file.delete();
        }
        int currentInboundChunkNo = 0;
        long cumulatedLen = 0L;
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        byte[] localDigest = null;
        DigestOutputStream digestOutputStream = new DigestOutputStream(new BufferedOutputStream(fileOutputStream, reply.getChunkLength()), MessageDigest.getInstance(linkParser.getDigestType()));
        try {
            while (true) {
                Message message;
                if ((message = this.accessorHolder.consumer.receive(RequestRegistry.SWIFTMQ_REQUEST_TIMEOUT)) == null) {
                    throw new JMSException("Request timeout occured (" + RequestRegistry.SWIFTMQ_REQUEST_TIMEOUT + ") ms");
                }
                FileChunkRequest chunkRequest = (FileChunkRequest)this.messageBasedFactory.create(message);
                if (chunkRequest.getChunkNo() != currentInboundChunkNo + 1) {
                    throw new FiletransferException("ChunkNo out of order! Expecting " + (currentInboundChunkNo + 1) + " but was receiving " + chunkRequest.getChunkNo());
                }
                if (chunkRequest == null) continue;
                byte[] chunk = chunkRequest.getChunk();
                digestOutputStream.write(chunk);
                digestOutputStream.flush();
                cumulatedLen += (long)chunk.length;
                FileChunkReply chunkReply = null;
                if (chunkRequest.isReplyRequired()) {
                    chunkReply = (FileChunkReply)chunkRequest.createReplyInstance();
                }
                if (chunkReply != null) {
                    chunkReply.setOk(true);
                    chunkReply.setChunkNo(chunkRequest.getChunkNo());
                    if (progressListener != null) {
                        progressListener.progress(reply.getFilename(), chunkRequest.getChunkNo(), reply.getSize(), cumulatedLen, (int)(cumulatedLen * 100L / reply.getSize()));
                    }
                }
                currentInboundChunkNo = chunkRequest.getChunkNo();
                if (chunkRequest.isLast()) {
                    fileOutputStream.getFD().sync();
                    localDigest = digestOutputStream.getMessageDigest().digest();
                    digestOutputStream.close();
                    byte[] cacheDigest = new LinkParser(this.link).getDigest();
                    if (!Arrays.equals(localDigest, cacheDigest)) {
                        chunkReply.setOk(false);
                        chunkReply.setException("Cache digest is not equal to local digest");
                        this.accessorHolder.producer.send(chunkReply.toMessage());
                        throw new FiletransferException("Cache digest is not equal to local digest");
                    }
                    chunkReply.setLink(new LinkBuilder(linkParser.getRouterName(), linkParser.getCacheName(), linkParser.getFileKey(), linkParser.getDigestType(), localDigest).toString());
                    this.accessorHolder.producer.send(chunkReply.toMessage());
                    break;
                }
                if (chunkReply == null) continue;
                this.accessorHolder.producer.send(chunkReply.toMessage());
            }
        }
        catch (FiletransferException | IOException | JMSException e) {
            if (this.file.exists()) {
                this.file.delete();
            }
            throw e;
        }
        return this;
    }

    @Override
    public Filetransfer delete() throws FiletransferException, JMSException, IOException, NoSuchAlgorithmException {
        FileDeleteReply reply;
        this.checkState();
        if (this.link == null) {
            throw new NullPointerException("Link is not specified");
        }
        LinkParser linkParser = new LinkParser(this.link);
        String pwdHexDigest = null;
        if (this.password != null) {
            byte[] pwdigest = MessageDigest.getInstance(linkParser.getDigestType()).digest(this.password.getBytes());
            pwdHexDigest = Util.byteArrayToHexString(pwdigest);
        }
        if (!(reply = (FileDeleteReply)FiletransferImpl.request(new FileDeleteRequest(this.link, pwdHexDigest), this.accessorHolder, this.messageBasedFactory, null)).isOk()) {
            throw new FiletransferException(reply.getException());
        }
        return this;
    }

    @Override
    public List<String> query() throws Exception {
        this.checkState();
        FileQueryReply reply = (FileQueryReply)FiletransferImpl.request(new FileQueryRequest(this.selector), this.accessorHolder, this.messageBasedFactory, null);
        if (!reply.isOk()) {
            throw new FiletransferException(reply.getException());
        }
        return reply.getResult();
    }

    @Override
    public Map<String, Map<String, Object>> queryProperties() throws Exception {
        this.checkState();
        FileQueryPropsReply reply = (FileQueryPropsReply)FiletransferImpl.request(new FileQueryPropsRequest(this.link, this.selector), this.accessorHolder, this.messageBasedFactory, null);
        if (!reply.isOk()) {
            throw new FiletransferException(reply.getException());
        }
        return reply.getResult();
    }

    @Override
    public void close() {
        try {
            FiletransferImpl.request(new SessionCloseRequest(), this.accessorHolder, this.messageBasedFactory);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.accessorHolder.producer.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.accessorHolder.consumer.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.accessorHolder.session.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.accessorHolder.replyQueue.delete();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.closed = true;
    }
}

