/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.DestinationImpl;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.TemporaryQueueImpl;
import com.swiftmq.jms.TemporaryTopicImpl;
import com.swiftmq.jms.TopicImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DestinationFactory {
    public static final byte TYPE_QUEUE = 0;
    public static final byte TYPE_TOPIC = 1;
    public static final byte TYPE_TEMPTOPIC = 2;
    public static final byte TYPE_TEMPQUEUE = 3;

    public static final DestinationImpl createDestination(DataInput in) throws IOException {
        byte b = in.readByte();
        DestinationImpl dest = null;
        switch (b) {
            case 3: {
                dest = new TemporaryQueueImpl(null, null);
                break;
            }
            case 0: {
                dest = new QueueImpl();
                break;
            }
            case 1: {
                dest = new TopicImpl();
                break;
            }
            case 2: {
                dest = new TemporaryTopicImpl();
            }
        }
        dest.readContent(in);
        return dest;
    }

    public static final void dumpDestination(DestinationImpl dest, DataOutput out) throws IOException {
        out.writeByte(dest.getType());
        dest.writeContent(out);
    }
}

