/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.tools.security.SecureClassLoaderObjectInputStream;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage {
    static final String PROP_BUFFERSIZE = "swiftmq.jms.objectmessage.buffersize";
    static final int BUFFERSIZE = Integer.parseInt(System.getProperty("swiftmq.jms.objectmessage.buffersize", "8192"));
    boolean bodyReadOnly = false;
    byte[] array = null;
    int cnt = 0;
    boolean useThreadContextCL = false;

    @Override
    protected int getType() {
        return 3;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.cnt > 0) {
            out.writeByte(1);
            out.writeInt(this.cnt);
            out.write(this.array, 0, this.cnt);
        } else {
            out.writeByte(0);
        }
    }

    @Override
    protected void readBody(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            this.array = new byte[in.readInt()];
            in.readFully(this.array);
            this.cnt = this.array.length;
        } else {
            this.cnt = 0;
        }
    }

    public boolean isUseThreadContextCL() {
        return this.useThreadContextCL;
    }

    @Override
    public void setUseThreadContextCL(boolean useThreadContextCL) {
        this.useThreadContextCL = useThreadContextCL;
    }

    private void serialize(Serializable obj) throws IOException {
        DataByteArrayOutputStream bos = new DataByteArrayOutputStream(BUFFERSIZE);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.close();
        this.array = bos.getBuffer();
        this.cnt = bos.getCount();
    }

    private Serializable deserialize(byte[] b, ClassLoader loader) throws IOException, ClassNotFoundException {
        DataByteArrayInputStream bis = new DataByteArrayInputStream(b);
        SecureClassLoaderObjectInputStream ois = new SecureClassLoaderObjectInputStream(loader == null ? bis : bis, loader);
        Serializable obj = (Serializable)ois.readObject();
        ois.close();
        return obj;
    }

    public Serializable getObject(ClassLoader customLoader) throws JMSException {
        if (this.cnt > 0) {
            try {
                return this.deserialize(this.array, customLoader);
            }
            catch (Exception e) {
                throw new JMSException(e.toString());
            }
        }
        return null;
    }

    @Override
    public void setReadOnly(boolean b) {
        super.setReadOnly(b);
        this.bodyReadOnly = b;
    }

    public Serializable getObject() throws JMSException {
        return this.getObject(this.useThreadContextCL ? Thread.currentThread().getContextClassLoader() : null);
    }

    public void setObject(Serializable obj) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message is read only");
        }
        if (obj == null) {
            this.cnt = 0;
        } else {
            try {
                this.serialize(obj);
            }
            catch (Exception e) {
                throw new JMSException(e.toString());
            }
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.bodyReadOnly = false;
        this.cnt = 0;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer("[ObjectMessageImpl ");
        b.append(super.toString());
        b.append(" array=");
        b.append(this.array);
        b.append(" cnt=");
        b.append(this.cnt);
        b.append("]");
        return b.toString();
    }

    private static class CustomCLObjectInputStream
    extends ObjectInputStream {
        ClassLoader customLoader;

        CustomCLObjectInputStream(InputStream in, ClassLoader customLoader) throws IOException, StreamCorruptedException {
            super(in);
            this.customLoader = customLoader;
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            return Class.forName(v.getName(), false, this.customLoader);
        }
    }
}

