/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.primitives.Primitive;
import com.swiftmq.jms.primitives.PrimitiveFactory;
import com.swiftmq.jms.primitives._Boolean;
import com.swiftmq.jms.primitives._Byte;
import com.swiftmq.jms.primitives._Bytes;
import com.swiftmq.jms.primitives._Char;
import com.swiftmq.jms.primitives._Double;
import com.swiftmq.jms.primitives._Float;
import com.swiftmq.jms.primitives._Int;
import com.swiftmq.jms.primitives._Long;
import com.swiftmq.jms.primitives._Short;
import com.swiftmq.jms.primitives._String;
import com.swiftmq.tools.dump.Dumpable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;

public class StreamMessageImpl
extends MessageImpl
implements StreamMessage {
    static final int WRITE_ONLY = 0;
    static final int READ_ONLY = 1;
    static final int DEFAULT_SIZE = 32;
    int mode = 0;
    int pos = 0;
    byte[] lastBA = null;
    int amount = 0;
    Primitive[] elements = null;
    int nElements = 0;

    @Override
    protected int getType() {
        return 4;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        out.writeInt(this.nElements);
        if (this.nElements > 0) {
            for (int i = 0; i < this.nElements; ++i) {
                Dumpable d = (Dumpable)((Object)this.elements[i]);
                out.writeInt(d.getDumpId());
                d.writeContent(out);
            }
        }
    }

    @Override
    protected void readBody(DataInput in) throws IOException {
        this.nElements = in.readInt();
        if (this.nElements > 0) {
            this.elements = new Primitive[this.nElements];
            for (int i = 0; i < this.elements.length; ++i) {
                Dumpable d = (Dumpable)((Object)PrimitiveFactory.createInstance(in.readInt()));
                d.readContent(in);
                this.elements[i] = (Primitive)((Object)d);
            }
        }
    }

    private Object getValue(int index) throws MessageEOFException {
        if (this.elements == null || index >= this.nElements) {
            throw new MessageEOFException("end-of-stream reached");
        }
        Primitive primitive = this.elements[index];
        Object obj = primitive.getObject();
        if (!(obj instanceof byte[])) {
            this.lastBA = null;
            this.amount = 0;
        }
        return obj;
    }

    public boolean readBoolean() throws JMSException {
        Object obj;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        if ((obj = this.getValue(this.pos++)) instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            try {
                return Boolean.valueOf((String)obj);
            }
            catch (Exception e) {
                --this.pos;
                throw new MessageFormatException("can't convert " + (String)obj + " to boolean");
            }
        }
        --this.pos;
        throw new MessageFormatException("can't convert message value to boolean");
    }

    public byte readByte() throws JMSException {
        Object obj;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        if ((obj = this.getValue(this.pos++)) instanceof Byte) {
            return (Byte)obj;
        }
        if (obj instanceof String) {
            try {
                return new Byte((String)obj);
            }
            catch (NumberFormatException e) {
                --this.pos;
                throw e;
            }
        }
        --this.pos;
        throw new MessageFormatException("can't convert message value to byte");
    }

    public short readShort() throws JMSException {
        Object obj;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        if ((obj = this.getValue(this.pos++)) instanceof Short) {
            return (Short)obj;
        }
        if (obj instanceof String) {
            try {
                return new Short((String)obj);
            }
            catch (NumberFormatException e) {
                --this.pos;
                throw e;
            }
        }
        if (obj instanceof Byte) {
            try {
                return ((Byte)obj).shortValue();
            }
            catch (Exception e) {
                --this.pos;
                throw new MessageFormatException("can't convert " + (Long)obj + " to short");
            }
        }
        --this.pos;
        throw new MessageFormatException("can't convert property value to short");
    }

    public char readChar() throws JMSException {
        Object obj;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        if ((obj = this.getValue(this.pos++)) == null) {
            --this.pos;
            throw new NullPointerException();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        --this.pos;
        throw new MessageFormatException("can't convert message value to char");
    }

    public int readInt() throws JMSException {
        Object obj;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        if ((obj = this.getValue(this.pos++)) instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            try {
                return Integer.valueOf((String)obj);
            }
            catch (NumberFormatException e) {
                --this.pos;
                throw e;
            }
        }
        if (obj instanceof Short) {
            try {
                return ((Short)obj).intValue();
            }
            catch (Exception e) {
                --this.pos;
                throw new MessageFormatException("can't convert " + obj + " to int");
            }
        }
        if (obj instanceof Byte) {
            try {
                return ((Byte)obj).intValue();
            }
            catch (Exception e) {
                --this.pos;
                throw new MessageFormatException("can't convert " + obj + " to int");
            }
        }
        --this.pos;
        throw new MessageFormatException("can't convert message value to int");
    }

    public long readLong() throws JMSException {
        Object obj;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        if ((obj = this.getValue(this.pos++)) instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            try {
                return Long.valueOf((String)obj);
            }
            catch (NumberFormatException e) {
                --this.pos;
                throw e;
            }
        }
        if (obj instanceof Short) {
            try {
                return ((Short)obj).longValue();
            }
            catch (Exception e) {
                --this.pos;
                throw new MessageFormatException("can't convert " + obj + " to long");
            }
        }
        if (obj instanceof Integer) {
            try {
                return ((Integer)obj).longValue();
            }
            catch (Exception e) {
                --this.pos;
                throw new MessageFormatException("can't convert " + obj + " to long");
            }
        }
        if (obj instanceof Byte) {
            try {
                return ((Byte)obj).longValue();
            }
            catch (Exception e) {
                --this.pos;
                throw new MessageFormatException("can't convert " + obj + " to long");
            }
        }
        --this.pos;
        throw new MessageFormatException("can't convert message value to long");
    }

    public float readFloat() throws JMSException {
        Object obj;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        if ((obj = this.getValue(this.pos++)) instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof String) {
            try {
                return new Float((String)obj).floatValue();
            }
            catch (NumberFormatException e) {
                --this.pos;
                throw e;
            }
        }
        --this.pos;
        throw new MessageFormatException("can't convert message value to float");
    }

    public double readDouble() throws JMSException {
        Object obj;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        if ((obj = this.getValue(this.pos++)) instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Float) {
            try {
                return ((Float)obj).doubleValue();
            }
            catch (Exception e) {
                --this.pos;
                throw new MessageFormatException("can't convert " + obj + " to double");
            }
        }
        if (obj instanceof String) {
            try {
                return new Double((String)obj);
            }
            catch (NumberFormatException e) {
                --this.pos;
                throw e;
            }
        }
        --this.pos;
        throw new MessageFormatException("can't convert message value to double");
    }

    public String readString() throws JMSException {
        Object obj;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        if ((obj = this.getValue(this.pos++)) == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            throw new MessageFormatException("Type conversion from byte[] to String is invalid");
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public int readBytes(byte[] value) throws JMSException {
        Object obj;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        if (this.lastBA != null) {
            if (this.amount == this.lastBA.length) {
                this.lastBA = null;
                this.amount = 0;
                return -1;
            }
            int rest = this.lastBA.length - this.amount;
            int toRead = Math.min(rest, value.length);
            System.arraycopy(this.lastBA, this.amount, value, 0, toRead);
            this.amount += toRead;
            return toRead;
        }
        if ((obj = this.getValue(this.pos++)) == null) {
            return -1;
        }
        if (obj instanceof byte[]) {
            this.lastBA = (byte[])obj;
            int len = Math.min(this.lastBA.length, value.length);
            System.arraycopy(this.lastBA, 0, value, 0, len);
            this.amount = len;
            return len;
        }
        --this.pos;
        throw new MessageFormatException("can't convert message value to byte[]");
    }

    public Object readObject() throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        Object value = this.getValue(this.pos++);
        Object newValue = null;
        if (value instanceof Character) {
            newValue = new Character(((Character)value).charValue());
        } else if (value instanceof Boolean) {
            newValue = new Boolean((Boolean)value);
        } else if (value instanceof Byte) {
            newValue = new Byte((Byte)value);
        } else if (value instanceof Short) {
            newValue = new Short((Short)value);
        } else if (value instanceof Integer) {
            newValue = new Integer((Integer)value);
        } else if (value instanceof Long) {
            newValue = new Long((Long)value);
        } else if (value instanceof Float) {
            newValue = new Float(((Float)value).floatValue());
        } else if (value instanceof Double) {
            newValue = new Double((Double)value);
        } else if (value instanceof String) {
            newValue = new String((String)value);
        } else if (value instanceof byte[]) {
            newValue = ((byte[])value).clone();
        }
        return newValue;
    }

    private void checkElements() {
        if (this.elements == null) {
            this.elements = new Primitive[32];
            this.nElements = 0;
        } else if (this.nElements == this.elements.length) {
            Primitive[] p = new Primitive[this.elements.length + 32];
            System.arraycopy(this.elements, 0, p, 0, this.nElements);
            this.elements = p;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkElements();
        this.elements[this.nElements++] = new _Boolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkElements();
        this.elements[this.nElements++] = new _Byte(value);
    }

    public void writeShort(short value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkElements();
        this.elements[this.nElements++] = new _Short(value);
    }

    public void writeChar(char value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkElements();
        this.elements[this.nElements++] = new _Char(value);
    }

    public void writeInt(int value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkElements();
        this.elements[this.nElements++] = new _Int(value);
    }

    public void writeLong(long value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkElements();
        this.elements[this.nElements++] = new _Long(value);
    }

    public void writeFloat(float value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkElements();
        this.elements[this.nElements++] = new _Float(value);
    }

    public void writeDouble(double value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkElements();
        this.elements[this.nElements++] = new _Double(value);
    }

    public void writeString(String value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkElements();
        this.elements[this.nElements++] = new _String(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        byte[] array = new byte[length];
        System.arraycopy(value, offset, array, 0, length);
        this.checkElements();
        this.elements[this.nElements++] = new _Bytes(array);
    }

    public void writeObject(Object value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        Primitive newValue = null;
        if (value == null) {
            newValue = new _String(null);
        } else if (value instanceof Character) {
            newValue = new _Char(((Character)value).charValue());
        } else if (value instanceof Boolean) {
            newValue = new _Boolean((Boolean)value);
        } else if (value instanceof Byte) {
            newValue = new _Byte((Byte)value);
        } else if (value instanceof Short) {
            newValue = new _Short((Short)value);
        } else if (value instanceof Integer) {
            newValue = new _Int((Integer)value);
        } else if (value instanceof Long) {
            newValue = new _Long((Long)value);
        } else if (value instanceof Float) {
            newValue = new _Float(((Float)value).floatValue());
        } else if (value instanceof Double) {
            newValue = new _Double((Double)value);
        } else if (value instanceof String) {
            newValue = new _String((String)value);
        } else if (value instanceof byte[]) {
            newValue = new _Bytes((byte[])value);
        }
        if (newValue == null) {
            throw new JMSException("writeObject supports only Boolean, Byte, Short, Integer, Long, Float, Double, byte[], or String");
        }
        this.checkElements();
        this.elements[this.nElements++] = newValue;
    }

    @Override
    public void reset() throws JMSException {
        this.pos = 0;
        this.mode = 1;
    }

    @Override
    public void clearBody() throws JMSException {
        this.elements = null;
        this.nElements = 0;
        this.pos = 0;
        this.mode = 0;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer("[StreamMessageImpl ");
        b.append(super.toString());
        b.append(" elements=");
        b.append(this.elements);
        b.append(" nElements=");
        b.append(this.nElements);
        b.append("]");
        return b.toString();
    }
}

