/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jndi.SwiftMQObjectFactory;
import com.swiftmq.tools.util.LazyUTF8String;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class TopicImpl
extends QueueImpl
implements Topic {
    LazyUTF8String topicName;

    public TopicImpl(String topicName) {
        super(null);
        this.setTopicName(topicName);
    }

    public TopicImpl(String queueName, String topicName) {
        super(queueName);
        this.setTopicName(topicName);
    }

    public TopicImpl() {
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(TopicImpl.class.getName(), new StringRefAddr("topicName", this.topicName != null ? this.topicName.getString() : null), SwiftMQObjectFactory.class.getName(), null);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void unfoldBuffers() {
        super.unfoldBuffers();
        if (this.topicName != null) {
            this.topicName.getString(true);
        }
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        if (this.queueName == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.queueName.writeContent(out);
        }
        this.topicName.writeContent(out);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            this.queueName = new LazyUTF8String(in);
        }
        this.topicName = new LazyUTF8String(in);
    }

    public String getTopicName() throws JMSException {
        return this.topicName != null ? this.topicName.getString() : null;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName != null ? new LazyUTF8String(topicName) : null;
    }

    @Override
    public String toString() {
        return this.topicName != null ? this.topicName.getString() : null;
    }
}

