/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    byte[] branchQualifier = null;
    int formatId = 0;
    byte[] globalTransactionId = null;
    int hash = 0;
    boolean routing = false;

    public XidImpl(byte[] branchQualifier, int formatId, byte[] globalTransactionId) {
        this.branchQualifier = branchQualifier;
        this.formatId = formatId;
        this.globalTransactionId = globalTransactionId;
    }

    public XidImpl(Xid xid) {
        this.branchQualifier = xid.getBranchQualifier();
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
    }

    public XidImpl() {
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public boolean isRouting() {
        return this.routing;
    }

    public void setRouting(boolean routing) {
        this.routing = routing;
    }

    private boolean bytesEqual(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null || b == null && a != null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        XidImpl that = (XidImpl)obj;
        return this.routing == that.isRouting() && this.bytesEqual(this.branchQualifier, that.getBranchQualifier()) && this.bytesEqual(this.globalTransactionId, that.getGlobalTransactionId()) && this.formatId == that.getFormatId();
    }

    public void writeContent(DataOutput out) throws IOException {
        out.writeBoolean(this.routing);
        out.writeInt(this.formatId);
        if (this.branchQualifier != null) {
            out.writeByte(1);
            out.writeInt(this.branchQualifier.length);
            out.write(this.branchQualifier);
        } else {
            out.writeByte(0);
        }
        if (this.globalTransactionId != null) {
            out.writeByte(1);
            out.writeInt(this.globalTransactionId.length);
            out.write(this.globalTransactionId);
        } else {
            out.writeByte(0);
        }
    }

    public void readContent(DataInput in) throws IOException {
        this.routing = in.readBoolean();
        this.formatId = in.readInt();
        byte set = in.readByte();
        if (set == 1) {
            this.branchQualifier = new byte[in.readInt()];
            in.readFully(this.branchQualifier);
        }
        if ((set = in.readByte()) == 1) {
            this.globalTransactionId = new byte[in.readInt()];
            in.readFully(this.globalTransactionId);
        }
    }

    private int createByteHash(byte[] b) {
        int h = 0;
        for (int i = 0; i < b.length; ++i) {
            h += b[i];
        }
        return h;
    }

    private void createHash() {
        this.hash = this.formatId;
        if (this.branchQualifier != null) {
            this.hash += this.createByteHash(this.branchQualifier);
        }
        if (this.globalTransactionId != null) {
            this.hash += this.createByteHash(this.globalTransactionId);
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.createHash();
        }
        return this.hash;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("[XidImpl, branchQualifier=");
        b.append(new String(this.branchQualifier));
        b.append(", formatId=");
        b.append(this.formatId);
        b.append(", globalTransactionId=");
        b.append(new String(this.globalTransactionId));
        b.append(", routing=");
        b.append(this.routing);
        b.append("]");
        return b.toString();
    }
}

