/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v400;

import com.swiftmq.jms.smqp.v400.AssociateMessageReply;
import com.swiftmq.jms.smqp.v400.SMQPVisitor;
import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AssociateMessageRequest
extends Request {
    MessageIndex messageIndex = null;

    public AssociateMessageRequest(int dispatchId, MessageIndex messageIndex) {
        super(dispatchId, true);
        this.messageIndex = messageIndex;
    }

    @Override
    public int getDumpId() {
        return 185;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.messageIndex == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.messageIndex.writeContent(out);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        byte set = in.readByte();
        if (set == 0) {
            this.messageIndex = null;
        } else {
            this.messageIndex = new MessageIndex();
            this.messageIndex.readContent(in);
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new AssociateMessageReply();
    }

    public MessageIndex getMessageIndex() {
        return this.messageIndex;
    }

    public void setMessageIndex(MessageIndex messageIndex) {
        this.messageIndex = messageIndex;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitAssociateMessageRequest(this);
    }

    @Override
    public String toString() {
        return "[AssociateMessageRequest " + super.toString() + " messageIndex=" + this.messageIndex + "]";
    }
}

