/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v400;

import com.swiftmq.jms.smqp.v400.AsyncMessageDeliveryReply;
import com.swiftmq.jms.smqp.v400.SMQPVisitor;
import com.swiftmq.swiftlet.queue.MessageEntry;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AsyncMessageDeliveryRequest
extends Request {
    int listenerId = 0;
    MessageEntry messageEntry = null;
    MessageEntry[] bulk = null;
    int sessionDispatchId = 0;
    boolean requiresRestart = false;
    int recoveryEpoche = 0;

    public AsyncMessageDeliveryRequest(int dispatchId, int listenerId, MessageEntry messageEntry, int sessionDispatchId) {
        super(dispatchId, false);
        this.listenerId = listenerId;
        this.messageEntry = messageEntry;
        this.sessionDispatchId = sessionDispatchId;
    }

    public AsyncMessageDeliveryRequest(int dispatchId, int listenerId, MessageEntry[] bulk, int numberMessages, int sessionDispatchId) {
        super(dispatchId, false);
        this.listenerId = listenerId;
        this.sessionDispatchId = sessionDispatchId;
        this.bulk = new MessageEntry[numberMessages];
        System.arraycopy(bulk, 0, this.bulk, 0, numberMessages);
    }

    @Override
    public int getDumpId() {
        return 102;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeInt(this.listenerId);
        out.writeInt(this.sessionDispatchId);
        out.writeInt(this.recoveryEpoche);
        out.writeBoolean(this.requiresRestart);
        if (this.messageEntry == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.messageEntry.writeContent(out);
        }
        if (this.bulk == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(this.bulk.length);
            for (int i = 0; i < this.bulk.length; ++i) {
                this.bulk[i].writeContent(out);
            }
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.listenerId = in.readInt();
        this.sessionDispatchId = in.readInt();
        this.recoveryEpoche = in.readInt();
        this.requiresRestart = in.readBoolean();
        byte set = in.readByte();
        if (set == 0) {
            this.messageEntry = null;
        } else {
            this.messageEntry = new MessageEntry();
            this.messageEntry.readContent(in);
        }
        set = in.readByte();
        if (set == 0) {
            this.bulk = null;
        } else {
            this.bulk = new MessageEntry[in.readInt()];
            for (int i = 0; i < this.bulk.length; ++i) {
                MessageEntry entry = new MessageEntry();
                entry.readContent(in);
                this.bulk[i] = entry;
            }
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return this.isReplyRequired() ? new AsyncMessageDeliveryReply(this.sessionDispatchId) : null;
    }

    public int getListenerId() {
        return this.listenerId;
    }

    public void setListenerId(int listenerId) {
        this.listenerId = listenerId;
    }

    public boolean isRequiresRestart() {
        return this.requiresRestart;
    }

    public void setRequiresRestart(boolean requiresRestart) {
        this.requiresRestart = requiresRestart;
    }

    public boolean isBulk() {
        return this.bulk != null;
    }

    public int getRecoveryEpoche() {
        return this.recoveryEpoche;
    }

    public void setRecoveryEpoche(int recoveryEpoche) {
        this.recoveryEpoche = recoveryEpoche;
    }

    public AsyncMessageDeliveryRequest[] createRequests() {
        AsyncMessageDeliveryRequest[] requests = new AsyncMessageDeliveryRequest[this.bulk.length];
        for (int i = 0; i < this.bulk.length; ++i) {
            requests[i] = new AsyncMessageDeliveryRequest(-1, this.listenerId, this.bulk[i], this.sessionDispatchId);
            requests[i].setRecoveryEpoche(this.recoveryEpoche);
        }
        return requests;
    }

    public MessageEntry getMessageEntry() {
        return this.messageEntry;
    }

    public void setMessageEntry(MessageEntry messageEntry) {
        this.messageEntry = messageEntry;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitAsyncMessageDeliveryRequest(this);
    }

    @Override
    public String toString() {
        return "[AsyncMessageDeliveryRequest " + super.toString() + " listenerId=" + this.listenerId + " sessionDispatchId=" + this.sessionDispatchId + " recoveryEpoche=" + this.recoveryEpoche + " requiresRestart=" + this.requiresRestart + " messageEntry=" + this.messageEntry + " bulk=" + this.bulk + "]";
    }
}

