/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v400;

import com.swiftmq.jms.smqp.v400.AuthResponseReply;
import com.swiftmq.jms.smqp.v400.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class AuthResponseRequest
extends Request {
    Serializable response = null;

    public AuthResponseRequest(Serializable response) {
        super(0, true);
        this.response = response;
    }

    @Override
    public int getDumpId() {
        return 161;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.response == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            DataByteArrayOutputStream dos = new DataByteArrayOutputStream(256);
            new ObjectOutputStream(dos).writeObject(this.response);
            out.writeInt(dos.getCount());
            out.write(dos.getBuffer(), 0, dos.getCount());
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        byte set = in.readByte();
        if (set == 0) {
            this.response = null;
        } else {
            try {
                byte[] b = new byte[in.readInt()];
                in.readFully(b);
                this.response = (Serializable)new ObjectInputStream(new DataByteArrayInputStream(b)).readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public Serializable getResponse() {
        return this.response;
    }

    @Override
    protected Reply createReplyInstance() {
        return new AuthResponseReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitAuthResponseRequest(this);
    }

    @Override
    public String toString() {
        return "[AuthResponseRequest " + super.toString() + " response=" + this.response + "]";
    }
}

