/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v400;

import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.smqp.v400.CreateProducerReply;
import com.swiftmq.jms.smqp.v400.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CreateProducerRequest
extends Request {
    QueueImpl queue = null;

    public CreateProducerRequest(int dispatchId, QueueImpl queue) {
        super(dispatchId, true);
        this.queue = queue;
    }

    @Override
    public int getDumpId() {
        return 127;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.queue == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.queue.toString());
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        byte set = in.readByte();
        this.queue = set == 0 ? null : new QueueImpl(in.readUTF());
    }

    @Override
    protected Reply createReplyInstance() {
        return new CreateProducerReply();
    }

    public QueueImpl getQueue() {
        return this.queue;
    }

    public void setQueue(QueueImpl queue) {
        this.queue = queue;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitCreateProducerRequest(this);
    }

    @Override
    public String toString() {
        return "[CreateProducerRequest " + super.toString() + " queue=" + this.queue + "]";
    }
}

