/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v400;

import com.swiftmq.jms.DestinationFactory;
import com.swiftmq.jms.TopicImpl;
import com.swiftmq.jms.smqp.v400.CreateSubscriberReply;
import com.swiftmq.jms.smqp.v400.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CreateSubscriberRequest
extends Request {
    TopicImpl topic = null;
    String messageSelector = null;
    boolean noLocal = false;

    public CreateSubscriberRequest(int dispatchId, TopicImpl topic, String messageSelector, boolean noLocal) {
        super(dispatchId, true);
        this.topic = topic;
        this.messageSelector = messageSelector;
        this.noLocal = noLocal;
    }

    @Override
    public int getDumpId() {
        return 121;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeBoolean(this.noLocal);
        if (this.topic == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            DestinationFactory.dumpDestination(this.topic, out);
        }
        if (this.messageSelector == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.messageSelector);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.noLocal = in.readBoolean();
        byte set = in.readByte();
        this.topic = set == 0 ? null : (TopicImpl)DestinationFactory.createDestination(in);
        set = in.readByte();
        this.messageSelector = set == 0 ? null : in.readUTF();
    }

    @Override
    protected Reply createReplyInstance() {
        return new CreateSubscriberReply();
    }

    public TopicImpl getTopic() {
        return this.topic;
    }

    public void setTopic(TopicImpl topic) {
        this.topic = topic;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitCreateSubscriberRequest(this);
    }

    @Override
    public String toString() {
        return "[CreateSubscriberRequest " + super.toString() + " topic=" + this.topic + " messageSelector=" + this.messageSelector + "]";
    }
}

