/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v400;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.smqp.v400.ProduceMessageReply;
import com.swiftmq.jms.smqp.v400.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ProduceMessageRequest
extends Request {
    int queueProducerId;
    MessageImpl message = null;
    DataByteArrayOutputStream dos = null;
    boolean copyRequired = false;

    public ProduceMessageRequest(int dispatchId, int queueProducerId, MessageImpl message, boolean replyRequired) {
        this(dispatchId, queueProducerId, message, replyRequired, false);
    }

    public ProduceMessageRequest(int dispatchId, int queueProducerId, MessageImpl message, boolean replyRequired, boolean copyRequired) {
        super(dispatchId, replyRequired);
        this.queueProducerId = queueProducerId;
        this.copyRequired = copyRequired;
        this.message = message;
        if (message != null && copyRequired) {
            try {
                this.dos = new DataByteArrayOutputStream(2048);
                message.writeContent(this.dos);
                this.dos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getDumpId() {
        return 145;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeInt(this.queueProducerId);
        if (this.copyRequired) {
            out.write(this.dos.getBuffer(), 0, this.dos.getCount());
        } else {
            this.message.writeContent(out);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.queueProducerId = in.readInt();
        this.message = MessageImpl.createInstance(in.readInt());
        this.message.readContent(in);
    }

    @Override
    protected Reply createReplyInstance() {
        return this.isReplyRequired() ? new ProduceMessageReply() : null;
    }

    public int getQueueProducerId() {
        return this.queueProducerId;
    }

    public void setQueueProducerId(int queueProducerId) {
        this.queueProducerId = queueProducerId;
    }

    public MessageImpl getMessage() {
        return this.message;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitProduceMessageRequest(this);
    }

    @Override
    public String toString() {
        return "[ProduceMessageRequest " + super.toString() + " queueProducerId =" + this.queueProducerId + " copyRequired =" + this.copyRequired + " message=" + this.message + "]";
    }
}

