/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v400;

import com.swiftmq.jms.smqp.v400.SMQPVisitor;
import com.swiftmq.jms.smqp.v400.SetClientIdReply;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SetClientIdRequest
extends Request {
    String clientId;

    public SetClientIdRequest(String clientId) {
        super(0, true);
        this.clientId = clientId;
    }

    public SetClientIdRequest() {
        super(0, true);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.clientId == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.clientId);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        byte set = in.readByte();
        this.clientId = set == 0 ? null : in.readUTF();
    }

    public String getClientId() {
        return this.clientId;
    }

    @Override
    public int getDumpId() {
        return 157;
    }

    @Override
    protected Reply createReplyInstance() {
        return new SetClientIdReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitSetClientIdRequest(this);
    }

    @Override
    public String toString() {
        return "[SetClientIdRequest " + super.toString() + ", clientId=" + this.clientId + "]";
    }
}

