/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v400;

import com.swiftmq.jms.XidImpl;
import com.swiftmq.jms.smqp.v400.SMQPVisitor;
import com.swiftmq.jms.smqp.v400.XAResCommitReply;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class XAResCommitRequest
extends Request {
    XidImpl xid = null;
    boolean onePhase = false;
    Object[] messages = null;

    public XAResCommitRequest(int dispatchId, XidImpl xid, boolean onePhase) {
        super(dispatchId, true);
        this.xid = xid;
        this.onePhase = onePhase;
    }

    @Override
    public int getDumpId() {
        return 179;
    }

    @Override
    protected Reply createReplyInstance() {
        return new XAResCommitReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitXAResCommitRequest(this);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        this.xid.writeContent(out);
        out.writeBoolean(this.onePhase);
        if (this.messages == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(this.messages.length);
            for (int i = 0; i < this.messages.length; ++i) {
                byte[] msg = (byte[])this.messages[i];
                out.writeInt(msg.length);
                out.write(msg);
            }
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.xid = new XidImpl();
        this.xid.readContent(in);
        this.onePhase = in.readBoolean();
        byte set = in.readByte();
        if (set == 0) {
            this.messages = null;
        } else {
            int len = in.readInt();
            this.messages = new Object[len];
            for (int i = 0; i < len; ++i) {
                int msglen = in.readInt();
                byte[] arr = new byte[msglen];
                in.readFully(arr);
                this.messages[i] = arr;
            }
        }
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public boolean isOnePhase() {
        return this.onePhase;
    }

    public Object[] getMessages() {
        return this.messages;
    }

    public void setMessages(Object[] messages) {
        this.messages = messages;
    }

    @Override
    public String toString() {
        return "[XAResCommitRequest " + super.toString() + ", xid=" + this.xid + ", onePhase=" + this.onePhase + "]";
    }
}

