/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v500;

import com.swiftmq.jms.smqp.v500.CloseConsumerReply;
import com.swiftmq.jms.smqp.v500.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CloseConsumerRequest
extends Request {
    int sessionDispatchId = 0;
    int queueConsumerId = 0;
    String exception = null;

    public CloseConsumerRequest(int dispatchId, int sessionDispatchId, int queueConsumerId) {
        this(dispatchId, sessionDispatchId, queueConsumerId, null);
    }

    public CloseConsumerRequest(int dispatchId, int sessionDispatchId, int queueConsumerId, String exception) {
        super(dispatchId, true);
        this.sessionDispatchId = sessionDispatchId;
        this.queueConsumerId = queueConsumerId;
        this.exception = exception;
    }

    @Override
    public int getDumpId() {
        return 106;
    }

    public int getSessionDispatchId() {
        return this.sessionDispatchId;
    }

    public String getException() {
        return this.exception;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeInt(this.sessionDispatchId);
        out.writeInt(this.queueConsumerId);
        if (this.exception == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.exception);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.sessionDispatchId = in.readInt();
        this.queueConsumerId = in.readInt();
        byte set = in.readByte();
        if (set == 1) {
            this.exception = in.readUTF();
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new CloseConsumerReply();
    }

    public int getQueueConsumerId() {
        return this.queueConsumerId;
    }

    public void setQueueConsumerId(int queueConsumerId) {
        this.queueConsumerId = queueConsumerId;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitCloseConsumerRequest(this);
    }

    @Override
    public String toString() {
        return "[CloseConsumerRequest " + super.toString() + " sessionDispatchId=" + this.sessionDispatchId + " queueConsumerId=" + this.queueConsumerId + " exception=" + this.exception + "]";
    }
}

