/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v500;

import com.swiftmq.jms.DestinationFactory;
import com.swiftmq.jms.TopicImpl;
import com.swiftmq.jms.smqp.v500.CreatePublisherReply;
import com.swiftmq.jms.smqp.v500.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CreatePublisherRequest
extends Request {
    TopicImpl topic = null;

    public CreatePublisherRequest(int dispatchId, TopicImpl topic) {
        super(dispatchId, true);
        this.topic = topic;
    }

    @Override
    public int getDumpId() {
        return 129;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.topic == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            DestinationFactory.dumpDestination(this.topic, out);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        byte set = in.readByte();
        this.topic = set == 0 ? null : (TopicImpl)DestinationFactory.createDestination(in);
    }

    @Override
    protected Reply createReplyInstance() {
        return new CreatePublisherReply();
    }

    public TopicImpl getTopic() {
        return this.topic;
    }

    public void setTopic(TopicImpl topic) {
        this.topic = topic;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitCreatePublisherRequest(this);
    }

    @Override
    public String toString() {
        return "[CreatePublisherRequest " + super.toString() + " topic=" + this.topic + "]";
    }
}

