/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v500;

import com.swiftmq.jms.smqp.v500.DeleteDurableReply;
import com.swiftmq.jms.smqp.v500.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DeleteDurableRequest
extends Request {
    String durableName;

    public DeleteDurableRequest(int dispatchId, String durableName) {
        super(dispatchId, true);
        this.durableName = durableName;
    }

    @Override
    public int getDumpId() {
        return 125;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.durableName == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.durableName);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        byte set = in.readByte();
        this.durableName = set == 0 ? null : in.readUTF();
    }

    @Override
    protected Reply createReplyInstance() {
        return new DeleteDurableReply();
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void setDurableName(String durableName) {
        this.durableName = durableName;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitDeleteDurableRequest(this);
    }

    @Override
    public String toString() {
        return "[DeleteDurableRequest " + super.toString() + " durableName=" + this.durableName + "]";
    }
}

