/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v500;

import com.swiftmq.jms.smqp.v500.SMQPVisitor;
import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MessageDeliveredRequest
extends Request {
    int queueConsumerId = -1;
    MessageIndex messageIndex = null;

    public MessageDeliveredRequest(int dispatchId, int queueConsumerId, MessageIndex messageIndex) {
        super(dispatchId, false);
        this.queueConsumerId = queueConsumerId;
        this.messageIndex = messageIndex;
    }

    @Override
    public int getDumpId() {
        return 189;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeInt(this.queueConsumerId);
        if (this.messageIndex == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.messageIndex.writeContent(out);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.queueConsumerId = in.readInt();
        byte set = in.readByte();
        if (set == 0) {
            this.messageIndex = null;
        } else {
            this.messageIndex = new MessageIndex();
            this.messageIndex.readContent(in);
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return null;
    }

    public int getQueueConsumerId() {
        return this.queueConsumerId;
    }

    public void setQueueConsumerId(int queueConsumerId) {
        this.queueConsumerId = queueConsumerId;
    }

    public MessageIndex getMessageIndex() {
        return this.messageIndex;
    }

    public void setMessageIndex(MessageIndex messageIndex) {
        this.messageIndex = messageIndex;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visitMessageDeliveredRequest(this);
    }

    @Override
    public String toString() {
        return "[MessageDeliveredRequest " + super.toString() + " queueConsumerId=" + this.queueConsumerId + " messageIndex=" + this.messageIndex + "]";
    }
}

