/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v510;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.smqp.v510.ProduceMessageReply;
import com.swiftmq.jms.smqp.v510.SMQPUtil;
import com.swiftmq.jms.smqp.v510.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ProduceMessageRequest
extends Request {
    private int queueProducerId;
    private MessageImpl singleMessage;
    private byte[] messageCopy;

    public ProduceMessageRequest() {
        super(0, true);
    }

    public ProduceMessageRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public ProduceMessageRequest(int dispatchId, int queueProducerId, MessageImpl singleMessage, byte[] messageCopy) {
        super(dispatchId, true);
        this.queueProducerId = queueProducerId;
        this.singleMessage = singleMessage;
        this.messageCopy = messageCopy;
    }

    public int getQueueProducerId() {
        return this.queueProducerId;
    }

    public void setQueueProducerId(int queueProducerId) {
        this.queueProducerId = queueProducerId;
    }

    public MessageImpl getSingleMessage() {
        return this.singleMessage;
    }

    public void setSingleMessage(MessageImpl singleMessage) {
        this.singleMessage = singleMessage;
    }

    public byte[] getMessageCopy() {
        return this.messageCopy;
    }

    public void setMessageCopy(byte[] messageCopy) {
        this.messageCopy = messageCopy;
    }

    @Override
    public int getDumpId() {
        return 153;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.queueProducerId, out);
        if (this.singleMessage != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.singleMessage, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.messageCopy != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.messageCopy, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        boolean messageCopy_set;
        super.readContent(in);
        this.queueProducerId = SMQPUtil.read(this.queueProducerId, in);
        boolean singleMessage_set = in.readBoolean();
        if (singleMessage_set) {
            this.singleMessage = SMQPUtil.read(this.singleMessage, in);
        }
        if (messageCopy_set = in.readBoolean()) {
            this.messageCopy = SMQPUtil.read(this.messageCopy, in);
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new ProduceMessageReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[ProduceMessageRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("queueProducerId=");
        _b.append(this.queueProducerId);
        _b.append(", ");
        _b.append("singleMessage=");
        _b.append(this.singleMessage);
        _b.append(", ");
        _b.append("messageCopy=");
        _b.append(this.messageCopy);
        _b.append("]");
        return _b.toString();
    }
}

