/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v510;

import com.swiftmq.jms.smqp.v510.SMQPFactory;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.dump.DumpableFactory;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SMQPBulkRequest
extends Request {
    static final DumpableFactory factory = new SMQPFactory();
    public Object[] dumpables = null;
    public int len = 0;

    public SMQPBulkRequest() {
        super(0, false);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeInt(this.len);
        for (int i = 0; i < this.len; ++i) {
            Dumpalizer.dump(out, (Dumpable)this.dumpables[i]);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.len = in.readInt();
        this.dumpables = new Object[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.dumpables[i] = Dumpalizer.construct(in, factory);
        }
    }

    @Override
    public int getDumpId() {
        return 100;
    }

    @Override
    protected Reply createReplyInstance() {
        return null;
    }

    @Override
    public void accept(RequestVisitor visitor) {
    }

    private String dumpDumpables() {
        StringBuffer b = new StringBuffer("\n");
        for (int i = 0; i < this.len; ++i) {
            b.append(this.dumpables[i].toString());
            b.append("\n");
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[SMQPBulkRequest " + super.toString() + " len =" + this.len + " dumpables=" + this.dumpDumpables() + "]";
    }
}

