/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v510;

import com.swiftmq.jms.XidImpl;
import com.swiftmq.jms.smqp.v510.SMQPUtil;
import com.swiftmq.jms.smqp.v510.SMQPVisitor;
import com.swiftmq.jms.smqp.v510.XAResEndReply;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class XAResEndRequest
extends Request {
    private XidImpl xid;
    private int flags;
    private List messages;

    public XAResEndRequest() {
        super(0, true);
    }

    public XAResEndRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public XAResEndRequest(int dispatchId, XidImpl xid, int flags, List messages) {
        super(dispatchId, true);
        this.xid = xid;
        this.flags = flags;
        this.messages = messages;
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public void setXid(XidImpl xid) {
        this.xid = xid;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public List getMessages() {
        return this.messages;
    }

    public void setMessages(List messages) {
        this.messages = messages;
    }

    @Override
    public int getDumpId() {
        return 166;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.xid, out);
        SMQPUtil.write(this.flags, out);
        if (this.messages != null) {
            out.writeBoolean(true);
            SMQPUtil.writebytearray(this.messages, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.xid = SMQPUtil.read(this.xid, in);
        this.flags = SMQPUtil.read(this.flags, in);
        boolean messages_set = in.readBoolean();
        if (messages_set) {
            this.messages = SMQPUtil.readbytearray(this.messages, in);
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new XAResEndReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[XAResEndRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("xid=");
        _b.append(this.xid);
        _b.append(", ");
        _b.append("flags=");
        _b.append(this.flags);
        _b.append(", ");
        _b.append("messages=");
        _b.append(this.messages);
        _b.append("]");
        return _b.toString();
    }
}

