/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v600;

import com.swiftmq.jms.TopicImpl;
import com.swiftmq.jms.smqp.v600.CreateDurableReply;
import com.swiftmq.jms.smqp.v600.SMQPUtil;
import com.swiftmq.jms.smqp.v600.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CreateDurableRequest
extends Request {
    private TopicImpl topic;
    private String messageSelector;
    private boolean noLocal;
    private String durableName;

    public CreateDurableRequest() {
        super(0, true);
    }

    public CreateDurableRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public CreateDurableRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public CreateDurableRequest(int dispatchId, TopicImpl topic, String messageSelector, boolean noLocal, String durableName) {
        super(dispatchId, true);
        this.topic = topic;
        this.messageSelector = messageSelector;
        this.noLocal = noLocal;
        this.durableName = durableName;
    }

    public CreateDurableRequest(RequestRetryValidator validator, int dispatchId, TopicImpl topic, String messageSelector, boolean noLocal, String durableName) {
        super(dispatchId, true, validator);
        this.topic = topic;
        this.messageSelector = messageSelector;
        this.noLocal = noLocal;
        this.durableName = durableName;
    }

    public TopicImpl getTopic() {
        return this.topic;
    }

    public void setTopic(TopicImpl topic) {
        this.topic = topic;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void setDurableName(String durableName) {
        this.durableName = durableName;
    }

    @Override
    public int getDumpId() {
        return 123;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.topic, out);
        if (this.messageSelector != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.messageSelector, out);
        } else {
            out.writeBoolean(false);
        }
        SMQPUtil.write(this.noLocal, out);
        SMQPUtil.write(this.durableName, out);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.topic = SMQPUtil.read(this.topic, in);
        boolean messageSelector_set = in.readBoolean();
        if (messageSelector_set) {
            this.messageSelector = SMQPUtil.read(this.messageSelector, in);
        }
        this.noLocal = SMQPUtil.read(this.noLocal, in);
        this.durableName = SMQPUtil.read(this.durableName, in);
    }

    @Override
    protected Reply createReplyInstance() {
        return new CreateDurableReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v600/CreateDurableRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("topic=");
        _b.append(this.topic);
        _b.append(", ");
        _b.append("messageSelector=");
        _b.append(this.messageSelector);
        _b.append(", ");
        _b.append("noLocal=");
        _b.append(this.noLocal);
        _b.append(", ");
        _b.append("durableName=");
        _b.append(this.durableName);
        _b.append("]");
        return _b.toString();
    }
}

