/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v600;

import com.swiftmq.jms.smqp.v600.FetchBrowserMessageReply;
import com.swiftmq.jms.smqp.v600.SMQPUtil;
import com.swiftmq.jms.smqp.v600.SMQPVisitor;
import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FetchBrowserMessageRequest
extends Request {
    private int queueBrowserId;
    private boolean resetRequired;
    private MessageIndex lastMessageIndex;

    public FetchBrowserMessageRequest() {
        super(0, true);
    }

    public FetchBrowserMessageRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public FetchBrowserMessageRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public FetchBrowserMessageRequest(int dispatchId, int queueBrowserId, boolean resetRequired, MessageIndex lastMessageIndex) {
        super(dispatchId, true);
        this.queueBrowserId = queueBrowserId;
        this.resetRequired = resetRequired;
        this.lastMessageIndex = lastMessageIndex;
    }

    public FetchBrowserMessageRequest(RequestRetryValidator validator, int dispatchId, int queueBrowserId, boolean resetRequired, MessageIndex lastMessageIndex) {
        super(dispatchId, true, validator);
        this.queueBrowserId = queueBrowserId;
        this.resetRequired = resetRequired;
        this.lastMessageIndex = lastMessageIndex;
    }

    public int getQueueBrowserId() {
        return this.queueBrowserId;
    }

    public void setQueueBrowserId(int queueBrowserId) {
        this.queueBrowserId = queueBrowserId;
    }

    public boolean isResetRequired() {
        return this.resetRequired;
    }

    public void setResetRequired(boolean resetRequired) {
        this.resetRequired = resetRequired;
    }

    public MessageIndex getLastMessageIndex() {
        return this.lastMessageIndex;
    }

    public void setLastMessageIndex(MessageIndex lastMessageIndex) {
        this.lastMessageIndex = lastMessageIndex;
    }

    @Override
    public int getDumpId() {
        return 144;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.queueBrowserId, out);
        SMQPUtil.write(this.resetRequired, out);
        if (this.lastMessageIndex != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.lastMessageIndex, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.queueBrowserId = SMQPUtil.read(this.queueBrowserId, in);
        this.resetRequired = SMQPUtil.read(this.resetRequired, in);
        boolean lastMessageIndex_set = in.readBoolean();
        if (lastMessageIndex_set) {
            this.lastMessageIndex = SMQPUtil.read(this.lastMessageIndex, in);
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new FetchBrowserMessageReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v600/FetchBrowserMessageRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("queueBrowserId=");
        _b.append(this.queueBrowserId);
        _b.append(", ");
        _b.append("resetRequired=");
        _b.append(this.resetRequired);
        _b.append(", ");
        _b.append("lastMessageIndex=");
        _b.append(this.lastMessageIndex);
        _b.append("]");
        return _b.toString();
    }
}

