/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v600;

import com.swiftmq.jms.smqp.v600.RollbackReply;
import com.swiftmq.jms.smqp.v600.SMQPUtil;
import com.swiftmq.jms.smqp.v600.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RollbackRequest
extends Request {
    private int recoveryEpoche;

    public RollbackRequest() {
        super(0, true);
    }

    public RollbackRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public RollbackRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public RollbackRequest(int dispatchId, int recoveryEpoche) {
        super(dispatchId, true);
        this.recoveryEpoche = recoveryEpoche;
    }

    public RollbackRequest(RequestRetryValidator validator, int dispatchId, int recoveryEpoche) {
        super(dispatchId, true, validator);
        this.recoveryEpoche = recoveryEpoche;
    }

    public int getRecoveryEpoche() {
        return this.recoveryEpoche;
    }

    public void setRecoveryEpoche(int recoveryEpoche) {
        this.recoveryEpoche = recoveryEpoche;
    }

    @Override
    public int getDumpId() {
        return 158;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.recoveryEpoche, out);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.recoveryEpoche = SMQPUtil.read(this.recoveryEpoche, in);
    }

    @Override
    protected Reply createReplyInstance() {
        return new RollbackReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v600/RollbackRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("recoveryEpoche=");
        _b.append(this.recoveryEpoche);
        _b.append("]");
        return _b.toString();
    }
}

