/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v600;

import com.swiftmq.jms.smqp.v600.SMQPUtil;
import com.swiftmq.tools.requestreply.ReplyNE;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RouterConnectReply
extends ReplyNE {
    private String routerName;
    private boolean authRequired;
    private long keepaliveInterval;

    public RouterConnectReply(String routerName, boolean authRequired, long keepaliveInterval) {
        this.routerName = routerName;
        this.authRequired = authRequired;
        this.keepaliveInterval = keepaliveInterval;
    }

    protected RouterConnectReply() {
    }

    public String getRouterName() {
        return this.routerName;
    }

    public void setRouterName(String routerName) {
        this.routerName = routerName;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public void setAuthRequired(boolean authRequired) {
        this.authRequired = authRequired;
    }

    public long getKeepaliveInterval() {
        return this.keepaliveInterval;
    }

    public void setKeepaliveInterval(long keepaliveInterval) {
        this.keepaliveInterval = keepaliveInterval;
    }

    @Override
    public int getDumpId() {
        return 161;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.routerName != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.routerName, out);
        } else {
            out.writeBoolean(false);
        }
        SMQPUtil.write(this.authRequired, out);
        SMQPUtil.write(this.keepaliveInterval, out);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        boolean routerName_set = in.readBoolean();
        if (routerName_set) {
            this.routerName = SMQPUtil.read(this.routerName, in);
        }
        this.authRequired = SMQPUtil.read(this.authRequired, in);
        this.keepaliveInterval = SMQPUtil.read(this.keepaliveInterval, in);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v600/RouterConnectReply, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("routerName=");
        _b.append(this.routerName);
        _b.append(", ");
        _b.append("authRequired=");
        _b.append(this.authRequired);
        _b.append(", ");
        _b.append("keepaliveInterval=");
        _b.append(this.keepaliveInterval);
        _b.append("]");
        return _b.toString();
    }
}

