/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v600;

import com.swiftmq.jms.smqp.v600.RouterConnectReply;
import com.swiftmq.jms.smqp.v600.SMQPUtil;
import com.swiftmq.jms.smqp.v600.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RouterConnectRequest
extends Request {
    private String routerName;

    public RouterConnectRequest() {
        super(0, true);
    }

    public RouterConnectRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public RouterConnectRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public RouterConnectRequest(int dispatchId, String routerName) {
        super(dispatchId, true);
        this.routerName = routerName;
    }

    public RouterConnectRequest(RequestRetryValidator validator, int dispatchId, String routerName) {
        super(dispatchId, true, validator);
        this.routerName = routerName;
    }

    public String getRouterName() {
        return this.routerName;
    }

    public void setRouterName(String routerName) {
        this.routerName = routerName;
    }

    @Override
    public int getDumpId() {
        return 160;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.routerName, out);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.routerName = SMQPUtil.read(this.routerName, in);
    }

    @Override
    protected Reply createReplyInstance() {
        return new RouterConnectReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v600/RouterConnectRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("routerName=");
        _b.append(this.routerName);
        _b.append("]");
        return _b.toString();
    }
}

