/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v610;

import com.swiftmq.jms.smqp.v610.AcknowledgeMessageReply;
import com.swiftmq.jms.smqp.v610.SMQPUtil;
import com.swiftmq.jms.smqp.v610.SMQPVisitor;
import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AcknowledgeMessageRequest
extends Request {
    private int queueConsumerId;
    private MessageIndex messageIndex;

    public AcknowledgeMessageRequest() {
        super(0, true);
    }

    public AcknowledgeMessageRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public AcknowledgeMessageRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public AcknowledgeMessageRequest(int dispatchId, int queueConsumerId, MessageIndex messageIndex) {
        super(dispatchId, true);
        this.queueConsumerId = queueConsumerId;
        this.messageIndex = messageIndex;
    }

    public AcknowledgeMessageRequest(RequestRetryValidator validator, int dispatchId, int queueConsumerId, MessageIndex messageIndex) {
        super(dispatchId, true, validator);
        this.queueConsumerId = queueConsumerId;
        this.messageIndex = messageIndex;
    }

    public int getQueueConsumerId() {
        return this.queueConsumerId;
    }

    public void setQueueConsumerId(int queueConsumerId) {
        this.queueConsumerId = queueConsumerId;
    }

    public MessageIndex getMessageIndex() {
        return this.messageIndex;
    }

    public void setMessageIndex(MessageIndex messageIndex) {
        this.messageIndex = messageIndex;
    }

    @Override
    public int getDumpId() {
        return 101;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.queueConsumerId, out);
        if (this.messageIndex != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.messageIndex, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.queueConsumerId = SMQPUtil.read(this.queueConsumerId, in);
        boolean messageIndex_set = in.readBoolean();
        if (messageIndex_set) {
            this.messageIndex = SMQPUtil.read(this.messageIndex, in);
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new AcknowledgeMessageReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v610/AcknowledgeMessageRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("queueConsumerId=");
        _b.append(this.queueConsumerId);
        _b.append(", ");
        _b.append("messageIndex=");
        _b.append(this.messageIndex);
        _b.append("]");
        return _b.toString();
    }
}

