/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v610;

import com.swiftmq.jms.smqp.v610.CloseConsumerReply;
import com.swiftmq.jms.smqp.v610.SMQPUtil;
import com.swiftmq.jms.smqp.v610.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CloseConsumerRequest
extends Request {
    private int sessionDispatchId;
    private int queueConsumerId;
    private String consumerException;

    public CloseConsumerRequest() {
        super(0, true);
    }

    public CloseConsumerRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public CloseConsumerRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public CloseConsumerRequest(int dispatchId, int sessionDispatchId, int queueConsumerId, String consumerException) {
        super(dispatchId, true);
        this.sessionDispatchId = sessionDispatchId;
        this.queueConsumerId = queueConsumerId;
        this.consumerException = consumerException;
    }

    public CloseConsumerRequest(RequestRetryValidator validator, int dispatchId, int sessionDispatchId, int queueConsumerId, String consumerException) {
        super(dispatchId, true, validator);
        this.sessionDispatchId = sessionDispatchId;
        this.queueConsumerId = queueConsumerId;
        this.consumerException = consumerException;
    }

    public int getSessionDispatchId() {
        return this.sessionDispatchId;
    }

    public void setSessionDispatchId(int sessionDispatchId) {
        this.sessionDispatchId = sessionDispatchId;
    }

    public int getQueueConsumerId() {
        return this.queueConsumerId;
    }

    public void setQueueConsumerId(int queueConsumerId) {
        this.queueConsumerId = queueConsumerId;
    }

    public String getConsumerException() {
        return this.consumerException;
    }

    public void setConsumerException(String consumerException) {
        this.consumerException = consumerException;
    }

    @Override
    public int getDumpId() {
        return 111;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.sessionDispatchId, out);
        SMQPUtil.write(this.queueConsumerId, out);
        if (this.consumerException != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.consumerException, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.sessionDispatchId = SMQPUtil.read(this.sessionDispatchId, in);
        this.queueConsumerId = SMQPUtil.read(this.queueConsumerId, in);
        boolean consumerException_set = in.readBoolean();
        if (consumerException_set) {
            this.consumerException = SMQPUtil.read(this.consumerException, in);
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new CloseConsumerReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v610/CloseConsumerRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("sessionDispatchId=");
        _b.append(this.sessionDispatchId);
        _b.append(", ");
        _b.append("queueConsumerId=");
        _b.append(this.queueConsumerId);
        _b.append(", ");
        _b.append("consumerException=");
        _b.append(this.consumerException);
        _b.append("]");
        return _b.toString();
    }
}

