/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v610;

import com.swiftmq.jms.smqp.v610.CloseSessionReply;
import com.swiftmq.jms.smqp.v610.SMQPUtil;
import com.swiftmq.jms.smqp.v610.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CloseSessionRequest
extends Request {
    private int sessionDispatchId;

    public CloseSessionRequest() {
        super(0, true);
    }

    public CloseSessionRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public CloseSessionRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public CloseSessionRequest(int dispatchId, int sessionDispatchId) {
        super(dispatchId, true);
        this.sessionDispatchId = sessionDispatchId;
    }

    public CloseSessionRequest(RequestRetryValidator validator, int dispatchId, int sessionDispatchId) {
        super(dispatchId, true, validator);
        this.sessionDispatchId = sessionDispatchId;
    }

    public int getSessionDispatchId() {
        return this.sessionDispatchId;
    }

    public void setSessionDispatchId(int sessionDispatchId) {
        this.sessionDispatchId = sessionDispatchId;
    }

    @Override
    public int getDumpId() {
        return 115;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.sessionDispatchId, out);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.sessionDispatchId = SMQPUtil.read(this.sessionDispatchId, in);
    }

    @Override
    protected Reply createReplyInstance() {
        return new CloseSessionReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v610/CloseSessionRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("sessionDispatchId=");
        _b.append(this.sessionDispatchId);
        _b.append("]");
        return _b.toString();
    }
}

