/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v610;

import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.smqp.v610.CreateConsumerReply;
import com.swiftmq.jms.smqp.v610.SMQPUtil;
import com.swiftmq.jms.smqp.v610.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CreateConsumerRequest
extends Request {
    private QueueImpl queue;
    private String messageSelector;

    public CreateConsumerRequest() {
        super(0, true);
    }

    public CreateConsumerRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public CreateConsumerRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public CreateConsumerRequest(int dispatchId, QueueImpl queue, String messageSelector) {
        super(dispatchId, true);
        this.queue = queue;
        this.messageSelector = messageSelector;
    }

    public CreateConsumerRequest(RequestRetryValidator validator, int dispatchId, QueueImpl queue, String messageSelector) {
        super(dispatchId, true, validator);
        this.queue = queue;
        this.messageSelector = messageSelector;
    }

    public QueueImpl getQueue() {
        return this.queue;
    }

    public void setQueue(QueueImpl queue) {
        this.queue = queue;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    @Override
    public int getDumpId() {
        return 121;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.queue, out);
        if (this.messageSelector != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.messageSelector, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.queue = SMQPUtil.read(this.queue, in);
        boolean messageSelector_set = in.readBoolean();
        if (messageSelector_set) {
            this.messageSelector = SMQPUtil.read(this.messageSelector, in);
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new CreateConsumerReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v610/CreateConsumerRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("queue=");
        _b.append(this.queue);
        _b.append(", ");
        _b.append("messageSelector=");
        _b.append(this.messageSelector);
        _b.append("]");
        return _b.toString();
    }
}

