/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v630;

import com.swiftmq.jms.ToClientSerializer;
import com.swiftmq.jms.smqp.v630.AsyncMessageDeliveryReply;
import com.swiftmq.jms.smqp.v630.SMQPUtil;
import com.swiftmq.jms.smqp.v630.SMQPVisitor;
import com.swiftmq.swiftlet.queue.MessageEntry;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AsyncMessageDeliveryRequest
extends Request
implements ToClientSerializer {
    DataOutput out = null;
    private int listenerId;
    private MessageEntry messageEntry;
    private MessageEntry[] bulk;
    private int sessionDispatchId;
    private boolean requiresRestart;
    private int recoveryEpoche;

    public AsyncMessageDeliveryRequest() {
        super(0, true);
    }

    public AsyncMessageDeliveryRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public AsyncMessageDeliveryRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public AsyncMessageDeliveryRequest(int dispatchId, int listenerId, MessageEntry messageEntry, MessageEntry[] bulk, int sessionDispatchId, boolean requiresRestart, int recoveryEpoche) {
        super(dispatchId, true);
        this.listenerId = listenerId;
        this.messageEntry = messageEntry;
        this.bulk = bulk;
        this.sessionDispatchId = sessionDispatchId;
        this.requiresRestart = requiresRestart;
        this.recoveryEpoche = recoveryEpoche;
    }

    public AsyncMessageDeliveryRequest(RequestRetryValidator validator, int dispatchId, int listenerId, MessageEntry messageEntry, MessageEntry[] bulk, int sessionDispatchId, boolean requiresRestart, int recoveryEpoche) {
        super(dispatchId, true, validator);
        this.listenerId = listenerId;
        this.messageEntry = messageEntry;
        this.bulk = bulk;
        this.sessionDispatchId = sessionDispatchId;
        this.requiresRestart = requiresRestart;
        this.recoveryEpoche = recoveryEpoche;
    }

    public int getListenerId() {
        return this.listenerId;
    }

    public void setListenerId(int listenerId) {
        this.listenerId = listenerId;
    }

    public MessageEntry getMessageEntry() {
        return this.messageEntry;
    }

    public void setMessageEntry(MessageEntry messageEntry) {
        this.messageEntry = messageEntry;
    }

    public MessageEntry[] getBulk() {
        return this.bulk;
    }

    public void setBulk(MessageEntry[] bulk) {
        this.bulk = bulk;
    }

    public int getSessionDispatchId() {
        return this.sessionDispatchId;
    }

    public void setSessionDispatchId(int sessionDispatchId) {
        this.sessionDispatchId = sessionDispatchId;
    }

    public boolean isRequiresRestart() {
        return this.requiresRestart;
    }

    public void setRequiresRestart(boolean requiresRestart) {
        this.requiresRestart = requiresRestart;
    }

    public int getRecoveryEpoche() {
        return this.recoveryEpoche;
    }

    public void setRecoveryEpoche(int recoveryEpoche) {
        this.recoveryEpoche = recoveryEpoche;
    }

    @Override
    public int getDumpId() {
        return 105;
    }

    @Override
    public DataOutput getDataOutput() {
        return this.out;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        this.out = out;
        super.writeContent(out);
        SMQPUtil.write(this.listenerId, out);
        if (this.messageEntry != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.messageEntry, (ToClientSerializer)this);
        } else {
            out.writeBoolean(false);
        }
        if (this.bulk != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.bulk, (ToClientSerializer)this);
        } else {
            out.writeBoolean(false);
        }
        SMQPUtil.write(this.sessionDispatchId, out);
        SMQPUtil.write(this.requiresRestart, out);
        SMQPUtil.write(this.recoveryEpoche, out);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        boolean bulk_set;
        super.readContent(in);
        this.listenerId = SMQPUtil.read(this.listenerId, in);
        boolean messageEntry_set = in.readBoolean();
        if (messageEntry_set) {
            this.messageEntry = SMQPUtil.read(this.messageEntry, in);
        }
        if (bulk_set = in.readBoolean()) {
            this.bulk = SMQPUtil.read(this.bulk, in);
        }
        this.sessionDispatchId = SMQPUtil.read(this.sessionDispatchId, in);
        this.requiresRestart = SMQPUtil.read(this.requiresRestart, in);
        this.recoveryEpoche = SMQPUtil.read(this.recoveryEpoche, in);
    }

    @Override
    protected Reply createReplyInstance() {
        return new AsyncMessageDeliveryReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v630/AsyncMessageDeliveryRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("listenerId=");
        _b.append(this.listenerId);
        _b.append(", ");
        _b.append("messageEntry=");
        _b.append(this.messageEntry);
        _b.append(", ");
        _b.append("bulk=");
        _b.append(this.bulk);
        _b.append(", ");
        _b.append("sessionDispatchId=");
        _b.append(this.sessionDispatchId);
        _b.append(", ");
        _b.append("requiresRestart=");
        _b.append(this.requiresRestart);
        _b.append(", ");
        _b.append("recoveryEpoche=");
        _b.append(this.recoveryEpoche);
        _b.append("]");
        return _b.toString();
    }
}

