/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v630;

import com.swiftmq.jms.XidImpl;
import com.swiftmq.jms.smqp.v630.SMQPUtil;
import com.swiftmq.jms.smqp.v630.SMQPVisitor;
import com.swiftmq.jms.smqp.v630.XAResEndReply;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class XAResEndRequest
extends Request {
    private XidImpl xid;
    private int flags;
    private boolean retry;
    private List messages;
    private List recoverRequestList;

    public XAResEndRequest() {
        super(0, true);
    }

    public XAResEndRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public XAResEndRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public XAResEndRequest(int dispatchId, XidImpl xid, int flags, boolean retry, List messages, List recoverRequestList) {
        super(dispatchId, true);
        this.xid = xid;
        this.flags = flags;
        this.retry = retry;
        this.messages = messages;
        this.recoverRequestList = recoverRequestList;
    }

    public XAResEndRequest(RequestRetryValidator validator, int dispatchId, XidImpl xid, int flags, boolean retry, List messages, List recoverRequestList) {
        super(dispatchId, true, validator);
        this.xid = xid;
        this.flags = flags;
        this.retry = retry;
        this.messages = messages;
        this.recoverRequestList = recoverRequestList;
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public void setXid(XidImpl xid) {
        this.xid = xid;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public List getMessages() {
        return this.messages;
    }

    public void setMessages(List messages) {
        this.messages = messages;
    }

    public List getRecoverRequestList() {
        return this.recoverRequestList;
    }

    public void setRecoverRequestList(List recoverRequestList) {
        this.recoverRequestList = recoverRequestList;
    }

    @Override
    public int getDumpId() {
        return 167;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.xid, out);
        SMQPUtil.write(this.flags, out);
        SMQPUtil.write(this.retry, out);
        if (this.messages != null) {
            out.writeBoolean(true);
            SMQPUtil.writeMessageList(this.messages, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.recoverRequestList != null) {
            out.writeBoolean(true);
            SMQPUtil.writeRequest(this.recoverRequestList, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        boolean recoverRequestList_set;
        super.readContent(in);
        this.xid = SMQPUtil.read(this.xid, in);
        this.flags = SMQPUtil.read(this.flags, in);
        this.retry = SMQPUtil.read(this.retry, in);
        boolean messages_set = in.readBoolean();
        if (messages_set) {
            this.messages = SMQPUtil.readMessageList(this.messages, in);
        }
        if (recoverRequestList_set = in.readBoolean()) {
            this.recoverRequestList = SMQPUtil.readRequest(this.recoverRequestList, in);
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new XAResEndReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v630/XAResEndRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("xid=");
        _b.append(this.xid);
        _b.append(", ");
        _b.append("flags=");
        _b.append(this.flags);
        _b.append(", ");
        _b.append("retry=");
        _b.append(this.retry);
        _b.append(", ");
        _b.append("messages=");
        _b.append(this.messages);
        _b.append(", ");
        _b.append("recoverRequestList=");
        _b.append(this.recoverRequestList);
        _b.append("]");
        return _b.toString();
    }
}

