/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v750;

import com.swiftmq.jms.smqp.v750.CommitReply;
import com.swiftmq.jms.smqp.v750.SMQPUtil;
import com.swiftmq.jms.smqp.v750.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class CommitRequest
extends Request {
    private List messages;

    public CommitRequest() {
        super(0, true);
    }

    public CommitRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public CommitRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public CommitRequest(int dispatchId, List messages) {
        super(dispatchId, true);
        this.messages = messages;
    }

    public CommitRequest(RequestRetryValidator validator, int dispatchId, List messages) {
        super(dispatchId, true, validator);
        this.messages = messages;
    }

    public List getMessages() {
        return this.messages;
    }

    public void setMessages(List messages) {
        this.messages = messages;
    }

    @Override
    public int getDumpId() {
        return 117;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.messages != null) {
            out.writeBoolean(true);
            SMQPUtil.writeMessageList(this.messages, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        boolean messages_set = in.readBoolean();
        if (messages_set) {
            this.messages = SMQPUtil.readMessageList(this.messages, in);
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new CommitReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v750/CommitRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("messages=");
        _b.append(this.messages);
        _b.append("]");
        return _b.toString();
    }
}

