/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v750;

import com.swiftmq.jms.TopicImpl;
import com.swiftmq.jms.smqp.v750.CreateSubscriberReply;
import com.swiftmq.jms.smqp.v750.SMQPUtil;
import com.swiftmq.jms.smqp.v750.SMQPVisitor;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CreateSubscriberRequest
extends Request {
    private TopicImpl topic;
    private String messageSelector;
    private boolean noLocal;
    private boolean autoCommit;

    public CreateSubscriberRequest() {
        super(0, true);
    }

    public CreateSubscriberRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public CreateSubscriberRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public CreateSubscriberRequest(int dispatchId, TopicImpl topic, String messageSelector, boolean noLocal, boolean autoCommit) {
        super(dispatchId, true);
        this.topic = topic;
        this.messageSelector = messageSelector;
        this.noLocal = noLocal;
        this.autoCommit = autoCommit;
    }

    public CreateSubscriberRequest(RequestRetryValidator validator, int dispatchId, TopicImpl topic, String messageSelector, boolean noLocal, boolean autoCommit) {
        super(dispatchId, true, validator);
        this.topic = topic;
        this.messageSelector = messageSelector;
        this.noLocal = noLocal;
        this.autoCommit = autoCommit;
    }

    public TopicImpl getTopic() {
        return this.topic;
    }

    public void setTopic(TopicImpl topic) {
        this.topic = topic;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Override
    public int getDumpId() {
        return 133;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.topic, out);
        if (this.messageSelector != null) {
            out.writeBoolean(true);
            SMQPUtil.write(this.messageSelector, out);
        } else {
            out.writeBoolean(false);
        }
        SMQPUtil.write(this.noLocal, out);
        SMQPUtil.write(this.autoCommit, out);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.topic = SMQPUtil.read(this.topic, in);
        boolean messageSelector_set = in.readBoolean();
        if (messageSelector_set) {
            this.messageSelector = SMQPUtil.read(this.messageSelector, in);
        }
        this.noLocal = SMQPUtil.read(this.noLocal, in);
        this.autoCommit = SMQPUtil.read(this.autoCommit, in);
    }

    @Override
    protected Reply createReplyInstance() {
        return new CreateSubscriberReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v750/CreateSubscriberRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("topic=");
        _b.append(this.topic);
        _b.append(", ");
        _b.append("messageSelector=");
        _b.append(this.messageSelector);
        _b.append(", ");
        _b.append("noLocal=");
        _b.append(this.noLocal);
        _b.append(", ");
        _b.append("autoCommit=");
        _b.append(this.autoCommit);
        _b.append("]");
        return _b.toString();
    }
}

