/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.springsupport;

import com.swiftmq.jms.springsupport.ConsumerKey;
import com.swiftmq.jms.springsupport.PooledConsumer;
import com.swiftmq.jms.springsupport.PooledProducer;
import com.swiftmq.jms.springsupport.SharedJMSConnection;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class PooledSession
implements Session,
QueueSession,
TopicSession {
    static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.springsupport.debug", "false"));
    private static final String NULL_DESTINATION = "_NULL_";
    SharedJMSConnection internalConnection = null;
    Session internalSession = null;
    Map consumerPool = new HashMap();
    Map producerPool = new HashMap();

    public PooledSession(SharedJMSConnection internalConnection, Session internalSession) {
        this.internalConnection = internalConnection;
        this.internalSession = internalSession;
        if (DEBUG) {
            System.out.println(this.toString() + "/created");
        }
    }

    protected synchronized void checkIn(PooledConsumer pooledConsumer) {
        if (DEBUG) {
            System.out.println(this.toString() + "/checkIn, pooledConsumer=" + pooledConsumer);
        }
        this.consumerPool.put(pooledConsumer.getKey().getKey(), pooledConsumer);
    }

    protected synchronized void checkIn(PooledProducer pooledProducer) {
        if (DEBUG) {
            System.out.println(this.toString() + "/checkIn, pooledProducer=" + pooledProducer);
        }
        try {
            Destination dest = pooledProducer.getDestination();
            String name = dest != null ? dest.toString() : NULL_DESTINATION;
            this.producerPool.put(name, pooledProducer);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public synchronized void checkExpired() {
        if (this.consumerPool.size() == 0 && this.producerPool.size() == 0) {
            return;
        }
        Iterator iter = this.consumerPool.entrySet().iterator();
        while (iter.hasNext()) {
            PooledConsumer pc = (PooledConsumer)iter.next().getValue();
            if (pc.getCheckInTime() + this.internalConnection.getPoolExpiration() > System.currentTimeMillis()) continue;
            if (DEBUG) {
                System.out.println(this.toString() + "/checkExpired, expired=" + pc);
            }
            pc.closeInternal();
            iter.remove();
        }
        iter = this.producerPool.entrySet().iterator();
        while (iter.hasNext()) {
            PooledProducer pp = (PooledProducer)iter.next().getValue();
            if (pp.getCheckInTime() + this.internalConnection.getPoolExpiration() > System.currentTimeMillis()) continue;
            if (DEBUG) {
                System.out.println(this.toString() + "/checkExpired, expired=" + pp);
            }
            pp.closeInternal();
            iter.remove();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createBytesMessage");
        }
        return this.internalSession.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createMapMessage");
        }
        return this.internalSession.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createMessage");
        }
        return this.internalSession.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createObjectMessage");
        }
        return this.internalSession.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createObjectMessage2");
        }
        return this.internalSession.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createStreamMessage");
        }
        return this.internalSession.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createTextMessage");
        }
        return this.internalSession.createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createTextMessage2");
        }
        return this.internalSession.createTextMessage(s);
    }

    public boolean getTransacted() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/getTransacted");
        }
        return this.internalSession.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/getAcknowledgeMode");
        }
        return this.internalSession.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/commit");
        }
        this.internalSession.commit();
    }

    public void rollback() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/rollback");
        }
        this.internalSession.rollback();
    }

    public void close() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/close");
        }
        this.internalConnection.checkIn(this);
    }

    protected void closeInternal() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/closeInternal");
        }
        Iterator iter = this.consumerPool.entrySet().iterator();
        while (iter.hasNext()) {
            PooledConsumer pc = (PooledConsumer)iter.next().getValue();
            if (DEBUG) {
                System.out.println(this.toString() + "/closeInternal, close=" + pc);
            }
            pc.closeInternal();
            iter.remove();
        }
        iter = this.producerPool.entrySet().iterator();
        while (iter.hasNext()) {
            PooledProducer pp = (PooledProducer)iter.next().getValue();
            if (DEBUG) {
                System.out.println(this.toString() + "/closeInternal, close=" + pp);
            }
            pp.closeInternal();
            iter.remove();
        }
        this.internalSession.close();
    }

    public void recover() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/recover");
        }
        this.internalSession.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/getMessageListener");
        }
        return this.internalSession.getMessageListener();
    }

    public void setMessageListener(MessageListener ml) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/setMessageListener, ml=" + ml);
        }
        this.internalSession.setMessageListener(ml);
    }

    public void run() {
        if (DEBUG) {
            System.out.println(this.toString() + "/run");
        }
        this.internalSession.run();
    }

    public Queue createQueue(String s) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createQueue, s=" + s);
        }
        return this.internalSession.createQueue(s);
    }

    public Topic createTopic(String s) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createTopic, s=" + s);
        }
        return this.internalSession.createTopic(s);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createBrowser, queue=" + queue);
        }
        return this.internalSession.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createBrowser, queue=" + queue + ", sel=" + string);
        }
        return this.internalSession.createBrowser(queue, string);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createTemporaryQueue");
        }
        return this.internalSession.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createTemporaryTopic");
        }
        return this.internalSession.createTemporaryTopic();
    }

    public void unsubscribe(String string) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/unsubscribe, s=" + string);
        }
        this.internalSession.unsubscribe(string);
    }

    public synchronized QueueSender createSender(Queue queue) throws JMSException {
        String name = queue != null ? queue.toString() : NULL_DESTINATION;
        PooledProducer pp = (PooledProducer)this.producerPool.remove(name);
        if (pp != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createSender, queue=" + name + ", return from pool");
            }
            return pp;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createSender, queue=" + name + ", creating new");
        }
        return new PooledProducer(this, this.internalSession.createProducer((Destination)queue), (Destination)queue);
    }

    public synchronized TopicPublisher createPublisher(Topic topic) throws JMSException {
        String name = topic != null ? topic.toString() : NULL_DESTINATION;
        PooledProducer pp = (PooledProducer)this.producerPool.remove(name);
        if (pp != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createPublisher, topic=" + name + ", return from pool");
            }
            return pp;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createPublisher, topic=" + name + ", creating new");
        }
        return new PooledProducer(this, this.internalSession.createProducer((Destination)topic), (Destination)topic);
    }

    public synchronized MessageProducer createProducer(Destination destination) throws JMSException {
        String name = destination != null ? destination.toString() : NULL_DESTINATION;
        PooledProducer pp = (PooledProducer)this.producerPool.remove(name);
        if (pp != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createProducer, destination=" + name + ", return from pool");
            }
            return pp;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createProducer, destination=" + name + ", creating new");
        }
        return new PooledProducer(this, this.internalSession.createProducer(destination), destination);
    }

    public synchronized QueueReceiver createReceiver(Queue queue) throws JMSException {
        ConsumerKey key = new ConsumerKey(queue.getQueueName(), null, true, null);
        PooledConsumer pc = (PooledConsumer)this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createReceiver, key=" + key + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createReceiver, key=" + key + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer((Destination)queue), (Destination)queue, true, key);
    }

    public synchronized QueueReceiver createReceiver(Queue queue, String s) throws JMSException {
        ConsumerKey key = new ConsumerKey(queue.getQueueName(), s, true, null);
        PooledConsumer pc = (PooledConsumer)this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createReceiver, key=" + key + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createReceiver, key=" + key + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer((Destination)queue, s), (Destination)queue, true, key);
    }

    public synchronized TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        ConsumerKey key = new ConsumerKey(topic.getTopicName(), null, true, null);
        PooledConsumer pc = (PooledConsumer)this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createSubscriber, key=" + key + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createSubscriber, key=" + key + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer((Destination)topic), (Destination)topic, true, key);
    }

    public synchronized TopicSubscriber createSubscriber(Topic topic, String s, boolean b) throws JMSException {
        ConsumerKey key = new ConsumerKey(topic.getTopicName(), s, b, null);
        PooledConsumer pc = (PooledConsumer)this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createSubscriber, key=" + key + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createSubscriber, key=" + key + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer((Destination)topic, s, b), (Destination)topic, b, key);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String s) throws JMSException {
        ConsumerKey key = new ConsumerKey(topic.getTopicName(), null, true, s);
        PooledConsumer pc = (PooledConsumer)this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createDurableSubscriber, key=" + key + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createDurableSubscriber, key=" + key + ", creating new");
        }
        return new PooledConsumer(this, (MessageConsumer)this.internalSession.createDurableSubscriber(topic, s), (Destination)topic, true, key);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String s, String s1, boolean b) throws JMSException {
        ConsumerKey key = new ConsumerKey(topic.getTopicName(), s1, b, s);
        PooledConsumer pc = (PooledConsumer)this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createDurableSubscriber, key=" + key + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createDurableSubscriber, key=" + key + ", creating new");
        }
        return new PooledConsumer(this, (MessageConsumer)this.internalSession.createDurableSubscriber(topic, s, s1, b), (Destination)topic, b, key);
    }

    public synchronized MessageConsumer createConsumer(Destination destination) throws JMSException {
        ConsumerKey key = new ConsumerKey(destination.toString(), null, true, null);
        PooledConsumer pc = (PooledConsumer)this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createConsumer, key=" + key + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createConsumer, key=" + key + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer(destination), destination, true, key);
    }

    public synchronized MessageConsumer createConsumer(Destination destination, String s) throws JMSException {
        ConsumerKey key = new ConsumerKey(destination.toString(), s, true, null);
        PooledConsumer pc = (PooledConsumer)this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createConsumer, key=" + key + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createConsumer, key=" + key + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer(destination, s), destination, true, key);
    }

    public synchronized MessageConsumer createConsumer(Destination destination, String s, boolean b) throws JMSException {
        ConsumerKey key = new ConsumerKey(destination.toString(), s, b, null);
        PooledConsumer pc = (PooledConsumer)this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createConsumer, key=" + key + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createConsumer, key=" + key + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer(destination, s, b), destination, b, key);
    }

    public String toString() {
        return "/PooledSession, internalSession=" + this.internalSession;
    }
}

