/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.springsupport;

import com.swiftmq.jms.springsupport.PooledSession;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class SharedJMSConnection
implements Connection,
QueueConnection,
TopicConnection {
    static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.springsupport.debug", "false"));
    Connection internalConnection = null;
    long poolExpiration = 0L;
    boolean firstTransacted = false;
    int firstAckMode = -1;
    List pool = new LinkedList();
    Timer timer = new Timer(true);
    TimerTask expiryChecker = null;

    public SharedJMSConnection(Connection internalConnection, long poolExpiration) {
        this.internalConnection = internalConnection;
        this.poolExpiration = poolExpiration;
        if (poolExpiration > 0L) {
            long delay = poolExpiration + 500L;
            this.expiryChecker = new TimerTask(){

                @Override
                public void run() {
                    SharedJMSConnection.this.checkExpired();
                }
            };
            this.timer.schedule(this.expiryChecker, delay, delay);
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/created");
        }
    }

    public long getPoolExpiration() {
        return this.poolExpiration;
    }

    public synchronized Session createSession(boolean transacted, int ackMode) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createSession, poolSize=" + this.pool.size());
        }
        if (this.pool.size() > 0) {
            PoolEntry entry = (PoolEntry)this.pool.remove(0);
            if (DEBUG) {
                System.out.println(this.toString() + "/createSession, returning session from pool: " + entry);
            }
            return entry.pooledSession;
        }
        if (this.firstAckMode == -1) {
            this.firstTransacted = transacted;
            this.firstAckMode = ackMode;
        } else if (transacted != this.firstTransacted || ackMode != this.firstAckMode) {
            throw new IllegalStateException("SharedJMSConnection: all JMS session must have the same transacted flag and ackMode!");
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createSession, returning a new session");
        }
        return new PooledSession(this, this.internalConnection.createSession(transacted, ackMode));
    }

    protected synchronized void checkIn(PooledSession pooledSession) {
        PoolEntry entry = new PoolEntry(System.currentTimeMillis(), pooledSession);
        if (this.pool.size() == 0) {
            this.pool.add(entry);
        } else {
            this.pool.add(0, entry);
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/checkIn, poolSize=" + this.pool.size() + ", entry=" + entry);
        }
    }

    public synchronized void checkExpired() {
        if (DEBUG) {
            System.out.println(this.toString() + "/checkExpired, poolSize=" + this.pool.size());
        }
        if (this.pool.size() == 0) {
            return;
        }
        Iterator iter = this.pool.iterator();
        while (iter.hasNext()) {
            PoolEntry entry = (PoolEntry)iter.next();
            long now = System.currentTimeMillis();
            if (DEBUG) {
                System.out.println(this.toString() + "/checkExpired, now=" + now + ", expTime=" + (entry.poolInsertionTime + this.poolExpiration));
            }
            entry.pooledSession.checkExpired();
            if (entry.poolInsertionTime + this.poolExpiration > now) continue;
            try {
                if (DEBUG) {
                    System.out.println(this.toString() + "/checkExpired, closing session=" + entry.pooledSession);
                }
                entry.pooledSession.closeInternal();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            iter.remove();
        }
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createQueueSession");
        }
        return (QueueSession)this.createSession(transacted, ackMode);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createTopicSession");
        }
        return (TopicSession)this.createSession(transacted, ackMode);
    }

    public String getClientID() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/getClientID");
        }
        return this.internalConnection.getClientID();
    }

    public void setClientID(String cid) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/setClientID, id=" + cid);
        }
        this.internalConnection.setClientID(cid);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/getMetaData");
        }
        return this.internalConnection.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/getExceptionListener");
        }
        return this.internalConnection.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/setExceptionListener");
        }
        this.internalConnection.setExceptionListener(exceptionListener);
    }

    public void start() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/start");
        }
        this.internalConnection.start();
    }

    public void stop() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/stop");
        }
        this.internalConnection.stop();
    }

    public void close() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/close (ignore)");
        }
    }

    public synchronized void destroy() throws Exception {
        if (DEBUG) {
            System.out.println(this.toString() + "/destroy");
        }
        if (this.pool.size() > 0) {
            Iterator iter = this.pool.iterator();
            while (iter.hasNext()) {
                PoolEntry entry = (PoolEntry)iter.next();
                if (DEBUG) {
                    System.out.println(this.toString() + "/destroy, closing session=" + entry.pooledSession);
                }
                entry.pooledSession.closeInternal();
                iter.remove();
            }
        }
        this.internalConnection.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int i) throws JMSException {
        throw new IllegalStateException("SharedJMSConnection: operation is not supported!");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        throw new IllegalStateException("SharedJMSConnection: operation is not supported!");
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int i) throws JMSException {
        throw new IllegalStateException("SharedJMSConnection: operation is not supported!");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int i) throws JMSException {
        throw new IllegalStateException("SharedJMSConnection: operation is not supported!");
    }

    public String toString() {
        return "/SharedJMSConnection";
    }

    private class PoolEntry {
        long poolInsertionTime = 0L;
        PooledSession pooledSession = null;

        public PoolEntry(long poolInsertionTime, PooledSession pooledSession) {
            this.poolInsertionTime = poolInsertionTime;
            this.pooledSession = pooledSession;
        }

        public String toString() {
            return "/PoolEntry, insertionTime=" + this.poolInsertionTime + ", pooledSession=" + this.pooledSession;
        }
    }
}

