/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v400;

import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.smqp.v400.CreateConsumerRequest;
import com.swiftmq.jms.v400.ConnectionConsumerImpl;
import com.swiftmq.jms.v400.ConnectionImpl;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.RequestRegistry;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;

public class QueueConnectionConsumerImpl
extends ConnectionConsumerImpl {
    String queueName = null;

    public QueueConnectionConsumerImpl(ConnectionImpl myConnection, int dispatchId, RequestRegistry requestRegistry, ServerSessionPool serverSessionPool, int maxMessages) {
        super(myConnection, dispatchId, requestRegistry, serverSessionPool, maxMessages);
    }

    void createConsumer(QueueImpl queue, String messageSelector) throws JMSException {
        if (queue == null) {
            throw new NullPointerException("createConsumer, queue is null!");
        }
        this.queueName = queue.getQueueName();
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CreateConsumerRequest(this.dispatchId, queue, messageSelector));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        this.fillCache();
    }

    @Override
    protected String getQueueName() {
        return this.queueName;
    }
}

