/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v400;

import com.swiftmq.jms.XidImpl;
import com.swiftmq.jms.smqp.v400.XAResCommitReply;
import com.swiftmq.jms.smqp.v400.XAResCommitRequest;
import com.swiftmq.jms.smqp.v400.XAResEndReply;
import com.swiftmq.jms.smqp.v400.XAResEndRequest;
import com.swiftmq.jms.smqp.v400.XAResPrepareReply;
import com.swiftmq.jms.smqp.v400.XAResPrepareRequest;
import com.swiftmq.jms.smqp.v400.XAResRecoverReply;
import com.swiftmq.jms.smqp.v400.XAResRecoverRequest;
import com.swiftmq.jms.smqp.v400.XAResRollbackReply;
import com.swiftmq.jms.smqp.v400.XAResRollbackRequest;
import com.swiftmq.jms.smqp.v400.XAResStartReply;
import com.swiftmq.jms.smqp.v400.XAResStartRequest;
import com.swiftmq.jms.v400.XASessionImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    XASessionImpl session = null;
    int dispatchId;
    Map xidMapping = new HashMap();
    Map xidContent = new HashMap();

    XAResourceImpl(XASessionImpl session) {
        this.session = session;
        session.session.setAutoAssign(false);
        this.dispatchId = session.getDispatchId();
    }

    private XidImpl toSwiftMQXid(Xid xid) {
        XidImpl rXid = null;
        if (xid instanceof XidImpl) {
            rXid = (XidImpl)xid;
        } else {
            rXid = (XidImpl)this.xidMapping.get(xid);
            if (rXid == null) {
                rXid = new XidImpl(xid);
                this.xidMapping.put(xid, rXid);
            }
        }
        return rXid;
    }

    private Xid[] toArray(List xidList) {
        if (xidList == null || xidList.size() == 0) {
            return new Xid[0];
        }
        Xid[] xids = new Xid[xidList.size()];
        for (int i = 0; i < xidList.size(); ++i) {
            xids[i] = (Xid)xidList.get(i);
        }
        return xids;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource resource) throws XAException {
        return this == resource;
    }

    @Override
    public synchronized Xid[] recover(int flag) throws XAException {
        XAResRecoverReply reply = null;
        try {
            reply = (XAResRecoverReply)this.session.request(new XAResRecoverRequest(this.dispatchId, flag));
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = 103;
            throw ex;
        }
        if (reply.isOk()) {
            return this.toArray(reply.getXids());
        }
        XAException ex = new XAException(reply.getException().getMessage());
        ex.errorCode = reply.getErrorCode();
        throw ex;
    }

    @Override
    public synchronized void start(Xid xid, int flags) throws XAException {
        XidImpl sxid = this.toSwiftMQXid(xid);
        XAResStartReply reply = null;
        try {
            reply = (XAResStartReply)this.session.request(new XAResStartRequest(this.dispatchId, sxid, flags));
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = 103;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        this.session.setCurrentTransaction((Object[])this.xidContent.remove(sxid));
        try {
            this.session.session.assignLastMessage();
        }
        catch (Exception e) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
    }

    @Override
    public synchronized void end(Xid xid, int flags) throws XAException {
        XidImpl sxid = this.toSwiftMQXid(xid);
        XAResEndReply reply = null;
        try {
            reply = (XAResEndReply)this.session.request(new XAResEndRequest(this.dispatchId, sxid, flags));
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = 103;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        Object[] content = this.session.getAndClearCurrentTransaction();
        if (content != null && content.length > 0) {
            this.xidContent.put(sxid, content);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XidImpl sxid = this.toSwiftMQXid(xid);
        this.xidContent.remove(sxid);
    }

    @Override
    public synchronized int prepare(Xid xid) throws XAException {
        XidImpl sxid = this.toSwiftMQXid(xid);
        XAResPrepareReply reply = null;
        try {
            reply = (XAResPrepareReply)this.session.request(new XAResPrepareRequest(this.dispatchId, sxid, (Object[])this.xidContent.remove(sxid)));
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = 103;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        return 0;
    }

    @Override
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        XidImpl sxid = this.toSwiftMQXid(xid);
        this.xidMapping.remove(xid);
        XAResCommitReply reply = null;
        try {
            XAResCommitRequest req = new XAResCommitRequest(this.dispatchId, sxid, onePhase);
            if (onePhase) {
                req.setMessages((Object[])this.xidContent.remove(sxid));
            }
            reply = (XAResCommitReply)this.session.request(req);
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = 103;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        if (reply.getDelay() > 0L) {
            try {
                Thread.sleep(reply.getDelay());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void rollback(Xid xid) throws XAException {
        XidImpl sxid = this.toSwiftMQXid(xid);
        this.xidMapping.remove(xid);
        XAResRollbackReply reply = null;
        try {
            this.session.getSessionImpl().startRecoverConsumers();
            this.xidContent.remove(sxid);
            reply = (XAResRollbackReply)this.session.request(new XAResRollbackRequest(this.dispatchId, sxid));
        }
        catch (Exception e) {
            e.printStackTrace();
            XAException ex = new XAException(e.toString());
            ex.errorCode = 103;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        this.session.getSessionImpl().endRecoverConsumers();
    }
}

