/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v500;

import com.swiftmq.client.thread.PoolManager;
import com.swiftmq.jms.CompoundConnectionFactory;
import com.swiftmq.jms.v500.ConnectionImpl;
import com.swiftmq.jms.v500.QueueConnectionImpl;
import com.swiftmq.jms.v500.TopicConnectionImpl;
import com.swiftmq.jms.v500.XAConnectionImpl;
import com.swiftmq.jms.v500.XAQueueConnectionImpl;
import com.swiftmq.jms.v500.XATopicConnectionImpl;
import com.swiftmq.jndi.v400.SwiftMQObjectFactory;
import com.swiftmq.net.SocketFactory;
import com.swiftmq.net.client.BlockingConnection;
import com.swiftmq.net.client.IntraVMConnection;
import com.swiftmq.swiftlet.SwiftletManager;
import com.swiftmq.swiftlet.net.NetworkSwiftlet;
import com.swiftmq.tools.dump.Dumpable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class ConnectionFactoryImpl
implements CompoundConnectionFactory,
Referenceable,
Serializable,
Dumpable {
    String listenerName = null;
    String socketFactoryClass = null;
    SocketFactory socketFactory = null;
    String hostname = null;
    int port = 0;
    long keepaliveInterval = 0L;
    String clientId = null;
    int smqpProducerReplyInterval = 0;
    int smqpConsumerCacheSize = 0;
    int jmsDeliveryMode = 0;
    int jmsPriority = 0;
    long jmsTTL = 0L;
    boolean jmsMessageIdEnabled = false;
    boolean jmsMessageTimestampEnabled = false;
    boolean useThreadContextCL = false;
    int inputBufferSize = 0;
    int inputExtendSize = 0;
    int outputBufferSize = 0;
    int outputExtendSize = 0;
    boolean intraVM = false;

    public ConnectionFactoryImpl(String listenerName, String socketFactoryClass, String hostname, int port, long keepaliveInterval, String clientId, int smqpProducerReplyInterval, int smqpConsumerCacheSize, int jmsDeliveryMode, int jmsPriority, long jmsTTL, boolean jmsMessageIdEnabled, boolean jmsMessageTimestampEnabled, boolean useThreadContextCL, int inputBufferSize, int inputExtendSize, int outputBufferSize, int outputExtendSize, boolean intraVM) {
        this.listenerName = listenerName;
        this.socketFactoryClass = socketFactoryClass;
        this.hostname = hostname;
        this.port = port;
        this.keepaliveInterval = keepaliveInterval;
        this.clientId = clientId;
        this.smqpProducerReplyInterval = smqpProducerReplyInterval;
        this.smqpConsumerCacheSize = smqpConsumerCacheSize;
        this.jmsDeliveryMode = jmsDeliveryMode;
        this.jmsPriority = jmsPriority;
        this.jmsTTL = jmsTTL;
        this.jmsMessageIdEnabled = jmsMessageIdEnabled;
        this.jmsMessageTimestampEnabled = jmsMessageTimestampEnabled;
        this.useThreadContextCL = useThreadContextCL;
        this.inputBufferSize = inputBufferSize;
        this.inputExtendSize = inputExtendSize;
        this.outputBufferSize = outputBufferSize;
        this.outputExtendSize = outputExtendSize;
        this.intraVM = intraVM;
    }

    public ConnectionFactoryImpl(String socketFactoryClass, String hostname, int port, long keepaliveInterval) {
        this(null, socketFactoryClass, hostname, port, keepaliveInterval, null, 20, 500, 2, 4, 0L, true, true, false, 131072, 65536, 131072, 65536, false);
    }

    public ConnectionFactoryImpl() {
    }

    @Override
    public int getDumpId() {
        return 0;
    }

    private void writeDump(DataOutput out, String s) throws IOException {
        if (s != null) {
            out.writeByte(1);
            out.writeUTF(s);
        } else {
            out.writeByte(0);
        }
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        this.writeDump(out, this.listenerName);
        this.writeDump(out, this.socketFactoryClass);
        this.writeDump(out, this.hostname);
        out.writeInt(this.port);
        out.writeLong(this.keepaliveInterval);
        this.writeDump(out, this.clientId);
        out.writeInt(this.smqpProducerReplyInterval);
        out.writeInt(this.smqpConsumerCacheSize);
        out.writeInt(this.jmsDeliveryMode);
        out.writeInt(this.jmsPriority);
        out.writeLong(this.jmsTTL);
        out.writeBoolean(this.jmsMessageIdEnabled);
        out.writeBoolean(this.jmsMessageTimestampEnabled);
        out.writeBoolean(this.useThreadContextCL);
        out.writeInt(this.inputBufferSize);
        out.writeInt(this.inputExtendSize);
        out.writeInt(this.outputBufferSize);
        out.writeInt(this.outputExtendSize);
        out.writeBoolean(this.intraVM);
    }

    private String readDump(DataInput in) throws IOException {
        String s = null;
        if (in.readByte() == 1) {
            s = in.readUTF();
        }
        return s;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.listenerName = this.readDump(in);
        this.socketFactoryClass = this.readDump(in);
        this.hostname = this.readDump(in);
        this.port = in.readInt();
        this.keepaliveInterval = in.readLong();
        this.clientId = this.readDump(in);
        this.smqpProducerReplyInterval = in.readInt();
        this.smqpConsumerCacheSize = in.readInt();
        this.jmsDeliveryMode = in.readInt();
        this.jmsPriority = in.readInt();
        this.jmsTTL = in.readLong();
        this.jmsMessageIdEnabled = in.readBoolean();
        this.jmsMessageTimestampEnabled = in.readBoolean();
        this.useThreadContextCL = in.readBoolean();
        this.inputBufferSize = in.readInt();
        this.inputExtendSize = in.readInt();
        this.outputBufferSize = in.readInt();
        this.outputExtendSize = in.readInt();
        this.intraVM = in.readBoolean();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(ConnectionFactoryImpl.class.getName(), new StringRefAddr("listenerName", this.listenerName), SwiftMQObjectFactory.class.getName(), null);
        ref.add(new StringRefAddr("socketFactoryClass", this.socketFactoryClass));
        ref.add(new StringRefAddr("hostname", this.hostname));
        ref.add(new StringRefAddr("port", String.valueOf(this.port)));
        ref.add(new StringRefAddr("keepaliveInterval", String.valueOf(this.keepaliveInterval)));
        if (this.clientId != null) {
            ref.add(new StringRefAddr("clientId", this.clientId));
        }
        ref.add(new StringRefAddr("smqpProducerReplyInterval", String.valueOf(this.smqpProducerReplyInterval)));
        ref.add(new StringRefAddr("smqpConsumerCacheSize", String.valueOf(this.smqpConsumerCacheSize)));
        ref.add(new StringRefAddr("jmsDeliveryMode", String.valueOf(this.jmsDeliveryMode)));
        ref.add(new StringRefAddr("jmsPriority", String.valueOf(this.jmsPriority)));
        ref.add(new StringRefAddr("jmsTTL", String.valueOf(this.jmsTTL)));
        ref.add(new StringRefAddr("jmsMessageIdEnabled", String.valueOf(this.jmsMessageIdEnabled)));
        ref.add(new StringRefAddr("jmsMessageTimestampEnabled", String.valueOf(this.jmsMessageTimestampEnabled)));
        ref.add(new StringRefAddr("useThreadContextCL", String.valueOf(this.useThreadContextCL)));
        ref.add(new StringRefAddr("inputBufferSize", String.valueOf(this.inputBufferSize)));
        ref.add(new StringRefAddr("inputExtendSize", String.valueOf(this.inputExtendSize)));
        ref.add(new StringRefAddr("outputBufferSize", String.valueOf(this.outputBufferSize)));
        ref.add(new StringRefAddr("outputExtendSize", String.valueOf(this.outputExtendSize)));
        ref.add(new StringRefAddr("intraVM", String.valueOf(this.intraVM)));
        return ref;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    private com.swiftmq.net.client.Connection createServerConnection() throws JMSException {
        PoolManager.setIntraVM(this.intraVM);
        com.swiftmq.net.client.Connection conn = null;
        if (this.intraVM) {
            try {
                conn = new IntraVMConnection();
                NetworkSwiftlet networkSwiftlet = (NetworkSwiftlet)SwiftletManager.getInstance().getSwiftlet("sys$net");
                networkSwiftlet.connectIntraVMListener("sys$jms", (IntraVMConnection)conn);
            }
            catch (Exception e) {
                throw new JMSException("error creating intraVM connection, message: " + e.getMessage());
            }
        }
        try {
            if (this.socketFactory == null) {
                this.socketFactory = (SocketFactory)Class.forName(this.socketFactoryClass).newInstance();
            }
            Socket socket = this.socketFactory.createSocket(this.hostname, this.port);
            conn = new BlockingConnection(socket, this.inputBufferSize, this.inputExtendSize, this.outputBufferSize, this.outputExtendSize);
        }
        catch (Exception e) {
            throw new JMSException("error creating socket connection to " + this.hostname + ":" + this.port + ", message: " + e.getMessage());
        }
        return conn;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        com.swiftmq.net.client.Connection conn = this.createServerConnection();
        ConnectionImpl qc = new ConnectionImpl(userName == null ? "anonymous" : userName, password, conn);
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(null, null);
    }

    public synchronized XAConnection createXAConnection(String userName, String password) throws JMSException {
        com.swiftmq.net.client.Connection conn = this.createServerConnection();
        XAConnectionImpl qc = new XAConnectionImpl(userName == null ? "anonymous" : userName, password, conn);
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public synchronized QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        com.swiftmq.net.client.Connection conn = this.createServerConnection();
        QueueConnectionImpl qc = new QueueConnectionImpl(userName == null ? "anonymous" : userName, password, conn);
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(null, null);
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        com.swiftmq.net.client.Connection conn = this.createServerConnection();
        XAQueueConnectionImpl qc = new XAQueueConnectionImpl(userName == null ? "anonymous" : userName, password, conn);
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public synchronized TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        com.swiftmq.net.client.Connection conn = this.createServerConnection();
        TopicConnectionImpl qc = new TopicConnectionImpl(userName == null ? "anonymous" : userName, password, conn);
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(null, null);
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        com.swiftmq.net.client.Connection conn = this.createServerConnection();
        XATopicConnectionImpl qc = new XATopicConnectionImpl(userName == null ? "anonymous" : userName, password, conn);
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[ConnectionFactoryImpl, socketFactoryClass=");
        s.append(this.socketFactoryClass);
        s.append(", hostname=");
        s.append(this.hostname);
        s.append(", port=");
        s.append(this.port);
        s.append(", keepaliveInterval=");
        s.append(this.keepaliveInterval);
        s.append(", clientId=");
        s.append(this.clientId);
        s.append(", smqpProducerReplyInterval=");
        s.append(this.smqpProducerReplyInterval);
        s.append(", smqpConsumerCacheSize=");
        s.append(this.smqpConsumerCacheSize);
        s.append(", jmsDeliveryMode=");
        s.append(this.jmsDeliveryMode);
        s.append(", jmsPriority=");
        s.append(this.jmsPriority);
        s.append(", jmsTTL=");
        s.append(this.jmsTTL);
        s.append(", jmsMessageIdEnabled=");
        s.append(this.jmsMessageIdEnabled);
        s.append(", jmsMessageTimestampEnabled=");
        s.append(this.jmsMessageTimestampEnabled);
        s.append(", useThreadContextCL=");
        s.append(this.useThreadContextCL);
        s.append(", inputBufferSize=");
        s.append(this.inputBufferSize);
        s.append(", inputExtendSize=");
        s.append(this.inputExtendSize);
        s.append(", outputBufferSize=");
        s.append(this.outputBufferSize);
        s.append(", outputExtendSize=");
        s.append(this.outputExtendSize);
        s.append(", intraVM=");
        s.append(this.intraVM);
        s.append("]");
        return s.toString();
    }
}

