/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v500;

import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.smqp.v500.CloseBrowserRequest;
import com.swiftmq.jms.smqp.v500.FetchBrowserMessageReply;
import com.swiftmq.jms.smqp.v500.FetchBrowserMessageRequest;
import com.swiftmq.jms.v500.SessionImpl;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.RequestRegistry;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class QueueBrowserImpl
implements QueueBrowser,
Enumeration {
    boolean closed = false;
    Queue queue = null;
    String messageSelector = null;
    int dispatchId = -1;
    int browserDispatchId = -1;
    RequestRegistry requestRegistry = null;
    Message lastMessage = null;
    SessionImpl mySession = null;
    boolean resetRequired = false;

    public QueueBrowserImpl(SessionImpl mySession, Queue queue, String messageSelector, int dispatchId, int browserDispatchId, RequestRegistry requestRegistry) {
        this.mySession = mySession;
        this.queue = queue;
        this.messageSelector = messageSelector;
        this.dispatchId = dispatchId;
        this.browserDispatchId = browserDispatchId;
        this.requestRegistry = requestRegistry;
    }

    protected void verifyState() throws JMSException {
        if (this.closed) {
            throw new JMSException("Queue browser is closed");
        }
        this.mySession.verifyState();
    }

    public Queue getQueue() throws JMSException {
        this.verifyState();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.verifyState();
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.verifyState();
        this.resetRequired = true;
        this.lastMessage = null;
        return this;
    }

    public void close() throws JMSException {
        this.verifyState();
        this.closed = true;
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CloseBrowserRequest(this.dispatchId, this.browserDispatchId));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
    }

    @Override
    public boolean hasMoreElements() {
        if (this.closed) {
            return false;
        }
        if (this.lastMessage == null) {
            Reply reply = null;
            try {
                reply = (FetchBrowserMessageReply)this.requestRegistry.request(new FetchBrowserMessageRequest(this.dispatchId, this.browserDispatchId, this.resetRequired));
                this.resetRequired = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (reply.isOk() && ((FetchBrowserMessageReply)reply).getMessageEntry() != null) {
                this.lastMessage = ((FetchBrowserMessageReply)reply).getMessageEntry().getMessage();
            }
        }
        return this.lastMessage != null;
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.closed || this.lastMessage == null) {
            throw new NoSuchElementException();
        }
        Message msg = this.lastMessage;
        this.lastMessage = null;
        return msg;
    }
}

