/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v500;

import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.TopicImpl;
import com.swiftmq.jms.smqp.v500.CreateDurableReply;
import com.swiftmq.jms.smqp.v500.CreateDurableRequest;
import com.swiftmq.jms.smqp.v500.CreateSubscriberReply;
import com.swiftmq.jms.smqp.v500.CreateSubscriberRequest;
import com.swiftmq.jms.v500.ConnectionConsumerImpl;
import com.swiftmq.jms.v500.ConnectionImpl;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.util.SwiftUtilities;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;

public class TopicConnectionConsumerImpl
extends ConnectionConsumerImpl {
    String queueName = null;

    public TopicConnectionConsumerImpl(ConnectionImpl myConnection, int dispatchId, RequestRegistry requestRegistry, ServerSessionPool serverSessionPool, int maxMessages) {
        super(myConnection, dispatchId, requestRegistry, serverSessionPool, maxMessages);
    }

    void createSubscriber(TopicImpl topic, String messageSelector) throws JMSException {
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CreateSubscriberRequest(this.dispatchId, topic, messageSelector, false));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        this.queueName = ((CreateSubscriberReply)reply).getTmpQueueName();
        this.fillCache();
    }

    void createDurableSubscriber(TopicImpl topic, String messageSelector, String durableName) throws JMSException {
        try {
            SwiftUtilities.verifyDurableName(durableName);
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
        CreateDurableReply reply = null;
        try {
            reply = (CreateDurableReply)this.requestRegistry.request(new CreateDurableRequest(this.dispatchId, topic, messageSelector, false, durableName));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        this.queueName = reply.getQueueName();
        this.fillCache();
    }

    @Override
    protected String getQueueName() {
        return this.queueName;
    }
}

