/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v500;

import com.swiftmq.jms.XACompletionListener;
import com.swiftmq.jms.XAResourceExtended;
import com.swiftmq.jms.XidImpl;
import com.swiftmq.jms.smqp.v500.XAResCommitReply;
import com.swiftmq.jms.smqp.v500.XAResCommitRequest;
import com.swiftmq.jms.smqp.v500.XAResEndReply;
import com.swiftmq.jms.smqp.v500.XAResEndRequest;
import com.swiftmq.jms.smqp.v500.XAResGetTxTimeoutReply;
import com.swiftmq.jms.smqp.v500.XAResGetTxTimeoutRequest;
import com.swiftmq.jms.smqp.v500.XAResPrepareReply;
import com.swiftmq.jms.smqp.v500.XAResPrepareRequest;
import com.swiftmq.jms.smqp.v500.XAResRecoverReply;
import com.swiftmq.jms.smqp.v500.XAResRecoverRequest;
import com.swiftmq.jms.smqp.v500.XAResRollbackReply;
import com.swiftmq.jms.smqp.v500.XAResRollbackRequest;
import com.swiftmq.jms.smqp.v500.XAResSetTxTimeoutReply;
import com.swiftmq.jms.smqp.v500.XAResSetTxTimeoutRequest;
import com.swiftmq.jms.smqp.v500.XAResStartReply;
import com.swiftmq.jms.smqp.v500.XAResStartRequest;
import com.swiftmq.jms.v500.XASessionImpl;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResourceExtended {
    XASessionImpl session = null;
    int dispatchId;
    Map xidMapping = new HashMap();
    XACompletionListener completionListener = null;
    int nRecoverCalls = 0;
    PrintWriter logWriter = null;

    XAResourceImpl(XASessionImpl session) {
        this.session = session;
        session.session.setAutoAssign(false);
        this.dispatchId = session.getDispatchId();
    }

    @Override
    public void setNeverSameRM(boolean neverSameRM) {
    }

    private XidImpl toSwiftMQXid(Xid xid) {
        XidImpl rXid = null;
        if (xid instanceof XidImpl) {
            rXid = (XidImpl)xid;
        } else {
            rXid = (XidImpl)this.xidMapping.get(xid);
            if (rXid == null) {
                rXid = new XidImpl(xid);
                this.xidMapping.put(xid, rXid);
            }
        }
        if (this.logWriter != null) {
            this.log(this.toString() + "/toSwiftMQXid, xid=" + xid + ", rXid=" + rXid);
        }
        return rXid;
    }

    private Xid[] toArray(List xidList) {
        if (this.logWriter != null) {
            this.log(this.toString() + "/toArray, xidList=" + xidList);
        }
        if (xidList == null || xidList.size() == 0) {
            return new Xid[0];
        }
        Xid[] xids = new Xid[xidList.size()];
        for (int i = 0; i < xidList.size(); ++i) {
            xids[i] = (Xid)xidList.get(i);
        }
        return xids;
    }

    private boolean isFlagSet(int flags, int flag) {
        return (flags & flag) == flag;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    protected void log(String msg) {
        try {
            this.logWriter.println(msg);
            this.logWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void setCompletionListener(XACompletionListener completionListener) {
        this.completionListener = completionListener;
    }

    @Override
    public String getRouterName() {
        return this.session.getSessionImpl().myConnection.metaData.getRouterName();
    }

    @Override
    public synchronized boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/setTransactionTimeout, seconds=" + seconds);
        }
        XAResSetTxTimeoutReply reply = null;
        try {
            reply = (XAResSetTxTimeoutReply)this.session.request(new XAResSetTxTimeoutRequest(this.dispatchId, seconds * 1000));
            if (!reply.isOk()) {
                throw reply.getException();
            }
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        return true;
    }

    @Override
    public synchronized int getTransactionTimeout() throws XAException {
        XAResGetTxTimeoutReply reply = null;
        try {
            reply = (XAResGetTxTimeoutReply)this.session.request(new XAResGetTxTimeoutRequest(this.dispatchId));
            if (!reply.isOk()) {
                throw reply.getException();
            }
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        int secs = (int)(reply.getTxTimeout() / 1000L);
        if (this.logWriter != null) {
            this.log(this.toString() + "/getTransactionTimeout, secs=" + secs);
        }
        return secs;
    }

    @Override
    public boolean isSameRM(XAResource resource) throws XAException {
        boolean b = false;
        if (resource instanceof XAResourceExtended) {
            XAResourceExtended that = (XAResourceExtended)resource;
            b = that.getRouterName().equals(this.getRouterName());
        }
        if (this.logWriter != null) {
            this.log(this.toString() + "/isSameRM, resource=" + resource + ", returns=" + b);
        }
        return b;
    }

    @Override
    public synchronized Xid[] recover(int flag) throws XAException {
        if (this.isFlagSet(flag, 0x1000000)) {
            if (this.logWriter != null) {
                this.log(this.toString() + "/TMSTARTRSCAN, flag=" + flag + ", nRecoverCalls=" + this.nRecoverCalls);
            }
            this.nRecoverCalls = 0;
        } else if (this.logWriter != null) {
            this.log(this.toString() + "/TMONOFLAGS, flag=" + flag + ", nRecoverCalls=" + this.nRecoverCalls);
        }
        if (this.nRecoverCalls > 0) {
            return new Xid[0];
        }
        ++this.nRecoverCalls;
        XAResRecoverReply reply = null;
        try {
            reply = (XAResRecoverReply)this.session.request(new XAResRecoverRequest(this.dispatchId, flag));
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (reply.isOk()) {
            return this.toArray(reply.getXids());
        }
        XAException ex = new XAException(reply.getException().getMessage());
        ex.errorCode = reply.getErrorCode();
        throw ex;
    }

    @Override
    public synchronized void start(Xid xid, int flags) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/start, xid=" + xid + ", flags=" + flags);
        }
        XidImpl sxid = this.toSwiftMQXid(xid);
        XAResStartReply reply = null;
        try {
            reply = (XAResStartReply)this.session.request(new XAResStartRequest(this.dispatchId, sxid, flags));
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        try {
            this.session.session.assignLastMessage();
        }
        catch (Exception e) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        if (this.completionListener != null) {
            this.completionListener.transactionStarted(sxid, this.session);
        }
    }

    @Override
    public synchronized void end(Xid xid, int flags) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/end, xid=" + xid + ", flags=" + flags);
        }
        XidImpl sxid = this.toSwiftMQXid(xid);
        XAResEndReply reply = null;
        try {
            Object[] content = this.session.getAndClearCurrentTransaction();
            if (content != null && content.length == 0) {
                content = null;
            }
            reply = (XAResEndReply)this.session.request(new XAResEndRequest(this.dispatchId, sxid, flags, content));
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        if (this.completionListener != null) {
            this.completionListener.transactionEnded(sxid);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/forget, xid=" + xid);
        }
    }

    @Override
    public synchronized int prepare(Xid xid) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/prepare, xid=" + xid);
        }
        XidImpl sxid = this.toSwiftMQXid(xid);
        XAResPrepareReply reply = null;
        try {
            reply = (XAResPrepareReply)this.session.request(new XAResPrepareRequest(this.dispatchId, sxid));
        }
        catch (Exception e) {
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (!reply.isOk()) {
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        return 0;
    }

    @Override
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/commit, xid=" + xid + ", onePhase=" + onePhase);
        }
        XidImpl sxid = this.toSwiftMQXid(xid);
        this.xidMapping.remove(xid);
        XAResCommitReply reply = null;
        try {
            XAResCommitRequest req = new XAResCommitRequest(this.dispatchId, sxid, onePhase);
            reply = (XAResCommitReply)this.session.request(req);
        }
        catch (Exception e) {
            if (this.completionListener != null) {
                this.completionListener.transactionCommitted(sxid);
            }
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (!reply.isOk()) {
            if (this.completionListener != null) {
                this.completionListener.transactionCommitted(sxid);
            }
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
        if (reply.getDelay() > 0L) {
            try {
                Thread.sleep(reply.getDelay());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.completionListener != null) {
            this.completionListener.transactionCommitted(sxid);
        }
    }

    @Override
    public synchronized void rollback(Xid xid) throws XAException {
        if (this.logWriter != null) {
            this.log(this.toString() + "/rollback, xid=" + xid);
        }
        XidImpl sxid = this.toSwiftMQXid(xid);
        this.xidMapping.remove(xid);
        XAResRollbackReply reply = null;
        try {
            this.session.getSessionImpl().startRecoverConsumers();
            this.session.getAndClearCurrentTransaction();
            reply = (XAResRollbackReply)this.session.request(new XAResRollbackRequest(this.dispatchId, sxid));
        }
        catch (Exception e) {
            if (this.completionListener != null) {
                this.completionListener.transactionAborted(sxid);
            }
            XAException ex = new XAException(e.toString());
            ex.errorCode = -7;
            throw ex;
        }
        if (reply.isOk()) {
            this.session.getSessionImpl().endRecoverConsumers();
            if (this.completionListener != null) {
                this.completionListener.transactionAborted(sxid);
            }
        } else {
            if (this.completionListener != null) {
                this.completionListener.transactionAborted(sxid);
            }
            XAException ex = new XAException(reply.getException().getMessage());
            ex.errorCode = reply.getErrorCode();
            throw ex;
        }
    }
}

