/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v510;

import com.swiftmq.auth.ChallengeResponseFactory;
import com.swiftmq.client.thread.PoolManager;
import com.swiftmq.jms.ConnectionLostException;
import com.swiftmq.jms.DestinationImpl;
import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.ReconnectListener;
import com.swiftmq.jms.SwiftMQConnection;
import com.swiftmq.jms.TopicImpl;
import com.swiftmq.jms.smqp.SMQPFactory;
import com.swiftmq.jms.smqp.SMQPVersionReply;
import com.swiftmq.jms.smqp.SMQPVersionRequest;
import com.swiftmq.jms.smqp.v510.AuthResponseReply;
import com.swiftmq.jms.smqp.v510.AuthResponseRequest;
import com.swiftmq.jms.smqp.v510.CreateSessionReply;
import com.swiftmq.jms.smqp.v510.CreateSessionRequest;
import com.swiftmq.jms.smqp.v510.DeleteTmpQueueRequest;
import com.swiftmq.jms.smqp.v510.DisconnectRequest;
import com.swiftmq.jms.smqp.v510.GetAuthChallengeReply;
import com.swiftmq.jms.smqp.v510.GetAuthChallengeRequest;
import com.swiftmq.jms.smqp.v510.GetClientIdReply;
import com.swiftmq.jms.smqp.v510.GetClientIdRequest;
import com.swiftmq.jms.smqp.v510.GetMetaDataReply;
import com.swiftmq.jms.smqp.v510.GetMetaDataRequest;
import com.swiftmq.jms.smqp.v510.KeepAliveRequest;
import com.swiftmq.jms.smqp.v510.SMQPBulkRequest;
import com.swiftmq.jms.smqp.v510.SetClientIdReply;
import com.swiftmq.jms.smqp.v510.SetClientIdRequest;
import com.swiftmq.jms.v510.ConnectionConsumerImpl;
import com.swiftmq.jms.v510.ConnectionMetaDataImpl;
import com.swiftmq.jms.v510.QueueConnectionConsumerImpl;
import com.swiftmq.jms.v510.SessionImpl;
import com.swiftmq.jms.v510.TopicConnectionConsumerImpl;
import com.swiftmq.net.client.ExceptionHandler;
import com.swiftmq.net.client.InboundHandler;
import com.swiftmq.swiftlet.threadpool.AsyncTask;
import com.swiftmq.swiftlet.threadpool.ThreadPool;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.dump.DumpableFactory;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.tools.queue.SingleProcessorQueue;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.ReplyHandler;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestHandler;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.requestreply.RequestServiceRegistry;
import com.swiftmq.tools.requestreply.TransportException;
import com.swiftmq.tools.timer.TimerEvent;
import com.swiftmq.tools.timer.TimerListener;
import com.swiftmq.tools.timer.TimerRegistry;
import com.swiftmq.tools.util.DataStreamOutputStream;
import com.swiftmq.tools.util.LengthCaptureDataInput;
import com.swiftmq.util.SwiftUtilities;
import java.io.IOException;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class ConnectionImpl
extends RequestServiceRegistry
implements SwiftMQConnection,
Connection,
ReplyHandler,
RequestHandler,
TimerListener,
InboundHandler,
ExceptionHandler {
    public static final String DISPATCH_TOKEN = "sys$jms.client.connection.connectiontask";
    public static final int CLIENT_VERSION = 510;
    public static final int DISCONNECTED = -1;
    public static final int CONNECTED_STOPPED = 0;
    public static final int CONNECTED_STARTED = 1;
    KeepAliveRequest keepaliveRequest = new KeepAliveRequest();
    boolean closed = false;
    int connectionState = -1;
    ConnectionMetaDataImpl metaData = null;
    String clientID = null;
    String internalCID = null;
    String originalCID = null;
    boolean clientIdAdministratively = false;
    String myHostname = null;
    ExceptionListener exceptionListener = null;
    RequestRegistry requestRegistry = null;
    Vector sessionList = new Vector();
    Vector connectionConsumerList = new Vector();
    DumpableFactory dumpableFactory = new SMQPFactory(new com.swiftmq.jms.smqp.v510.SMQPFactory());
    boolean cancelled = false;
    boolean clientIdAllowed = true;
    ChallengeResponseFactory crFactory = null;
    String userName = null;
    String password = null;
    com.swiftmq.net.client.Connection connection = null;
    long keepaliveInterval = 0L;
    int smqpProducerReplyInterval = 0;
    int smqpConsumerCacheSize = 0;
    int jmsDeliveryMode = 0;
    int jmsPriority = 0;
    long jmsTTL = 0L;
    boolean jmsMessageIdEnabled = false;
    boolean jmsMessageTimestampEnabled = false;
    boolean useThreadContextCL = false;
    ConnectionQueue connectionQueue = null;
    ConnectionTask connectionTask = null;
    ThreadPool connectionPool = null;
    DataStreamOutputStream outStream = null;

    protected ConnectionImpl(String userName, String password, com.swiftmq.net.client.Connection connection) throws JMSException {
        this.userName = userName;
        this.password = password;
        this.connection = connection;
        this.connectionPool = PoolManager.getInstance().getConnectionPool();
        this.connectionTask = new ConnectionTask();
        this.connectionQueue = new ConnectionQueue();
        this.connectionQueue.startQueue();
        this.myHostname = connection.getLocalHostname();
        this.requestRegistry = new RequestRegistry();
        this.requestRegistry.setRequestHandler(this);
        this.setReplyHandler(this);
        connection.setInboundHandler(this);
        connection.setExceptionHandler(this);
        this.outStream = new DataStreamOutputStream(connection.getOutputStream());
        try {
            connection.start();
            this.checkVersion();
            this.authenticate();
            this.fetchMetaData();
            this.connectionState = 0;
        }
        catch (Exception e) {
            connection.close();
            throw ExceptionConverter.convert(e);
        }
    }

    @Override
    public boolean isReconnectEnabled() {
        return false;
    }

    @Override
    public void addReconnectListener(ReconnectListener listener) {
    }

    @Override
    public void removeReconnectListener(ReconnectListener listener) {
    }

    private void fetchMetaData() throws JMSException {
        GetMetaDataReply mdReply = (GetMetaDataReply)this.requestRegistry.request(new GetMetaDataRequest());
        if (!mdReply.isOk()) {
            throw ExceptionConverter.convert(mdReply.getException());
        }
        this.metaData = mdReply.getMetaData();
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    void assignClientId(String clientId) throws JMSException {
        this.clientID = clientId;
        this.originalCID = clientId;
        if (this.clientID != null) {
            this.clientIdAdministratively = true;
            try {
                SetClientIdReply reply = (SetClientIdReply)this.requestRegistry.request(new SetClientIdRequest(0, this.clientID));
                if (!reply.isOk()) {
                    throw new JMSException(reply.getException().toString());
                }
                this.clientID = reply.getClientId();
            }
            catch (Exception e) {
                if (e instanceof JMSException) {
                    throw (JMSException)((Object)e);
                }
                e.printStackTrace();
            }
        } else {
            this.clientIdAdministratively = false;
            try {
                GetClientIdReply reply = (GetClientIdReply)this.requestRegistry.request(new GetClientIdRequest());
                if (!reply.isOk()) {
                    throw new JMSException(reply.getException().toString());
                }
                this.internalCID = reply.getClientId();
            }
            catch (Exception e) {
                if (e instanceof JMSException) {
                    throw (JMSException)((Object)e);
                }
                e.printStackTrace();
            }
        }
    }

    public String getInternalCID() {
        return this.internalCID;
    }

    int getSmqpProducerReplyInterval() {
        return this.smqpProducerReplyInterval;
    }

    void setSmqpProducerReplyInterval(int smqpProducerReplyInterval) {
        this.smqpProducerReplyInterval = smqpProducerReplyInterval;
    }

    int getSmqpConsumerCacheSize() {
        return this.smqpConsumerCacheSize;
    }

    void setSmqpConsumerCacheSize(int smqpConsumerCacheSize) {
        this.smqpConsumerCacheSize = smqpConsumerCacheSize;
    }

    int getJmsDeliveryMode() {
        return this.jmsDeliveryMode;
    }

    void setJmsDeliveryMode(int jmsDeliveryMode) {
        this.jmsDeliveryMode = jmsDeliveryMode;
    }

    int getJmsPriority() {
        return this.jmsPriority;
    }

    void setJmsPriority(int jmsPriority) {
        this.jmsPriority = jmsPriority;
    }

    long getJmsTTL() {
        return this.jmsTTL;
    }

    void setJmsTTL(long jmsTTL) {
        this.jmsTTL = jmsTTL;
    }

    boolean isJmsMessageIdEnabled() {
        return this.jmsMessageIdEnabled;
    }

    void setJmsMessageIdEnabled(boolean jmsMessageIdEnabled) {
        this.jmsMessageIdEnabled = jmsMessageIdEnabled;
    }

    boolean isJmsMessageTimestampEnabled() {
        return this.jmsMessageTimestampEnabled;
    }

    void setJmsMessageTimestampEnabled(boolean jmsMessageTimestampEnabled) {
        this.jmsMessageTimestampEnabled = jmsMessageTimestampEnabled;
    }

    boolean isUseThreadContextCL() {
        return this.useThreadContextCL;
    }

    void setUseThreadContextCL(boolean useThreadContextCL) {
        this.useThreadContextCL = useThreadContextCL;
    }

    void startKeepAlive(long keepaliveInterval) {
        this.keepaliveInterval = keepaliveInterval;
        TimerRegistry.Singleton().addTimerListener(keepaliveInterval, (TimerListener)this);
    }

    @Override
    public void performTimeAction(TimerEvent evt) {
        this.performRequest(this.keepaliveRequest);
    }

    protected void checkVersion() throws Exception {
        SMQPVersionReply reply = (SMQPVersionReply)this.requestRegistry.request(new SMQPVersionRequest(510));
        if (!reply.isOk()) {
            throw reply.getException();
        }
    }

    protected void authenticate() throws Exception {
        GetAuthChallengeReply gaReply = (GetAuthChallengeReply)this.requestRegistry.request(new GetAuthChallengeRequest(0, this.userName));
        byte[] challenge = null;
        if (!gaReply.isOk()) {
            throw gaReply.getException();
        }
        challenge = gaReply.getChallenge();
        this.crFactory = (ChallengeResponseFactory)Class.forName(gaReply.getFactoryClass()).newInstance();
        byte[] response = this.crFactory.createBytesResponse(challenge, this.password);
        AuthResponseReply arReply = (AuthResponseReply)this.requestRegistry.request(new AuthResponseRequest(0, response));
        if (!arReply.isOk()) {
            throw arReply.getException();
        }
    }

    protected void verifyState() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    void addSession(Session session) {
        this.clientIdAllowed = false;
        this.sessionList.addElement(session);
        if (this.connectionState == 1) {
            ((SessionImpl)session).startSession();
        }
    }

    void removeSession(Session session) {
        this.sessionList.removeElement(session);
    }

    void addConnectionConsumer(ConnectionConsumerImpl connectionConsumer) {
        this.connectionConsumerList.addElement(connectionConsumer);
        if (this.connectionState == 1) {
            connectionConsumer.startConsumer();
        }
    }

    void removeConnectionConsumer(ConnectionConsumerImpl connectionConsumer) {
        this.connectionConsumerList.removeElement(connectionConsumer);
    }

    public int getConnectionState() {
        return this.connectionState;
    }

    @Override
    public void deleteTempQueue(String queueName) throws JMSException {
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new DeleteTmpQueueRequest(0, queueName));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.verifyState();
        SessionImpl session = null;
        CreateSessionReply reply = null;
        try {
            reply = (CreateSessionReply)this.requestRegistry.request(new CreateSessionRequest(0, transacted, acknowledgeMode, 2));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        int dispatchId = reply.getSessionDispatchId();
        String cid = this.clientID != null ? this.clientID : this.internalCID;
        session = new SessionImpl(0, this, transacted, acknowledgeMode, dispatchId, this.requestRegistry, this.myHostname, cid);
        session.setUserName(this.getUserName());
        session.setMyDispatchId(this.addRequestService(session));
        this.addSession(session);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        String ms;
        this.verifyState();
        QueueConnectionConsumerImpl cc = null;
        CreateSessionReply reply = null;
        try {
            reply = (CreateSessionReply)this.requestRegistry.request(new CreateSessionRequest(0, false, 0, 0));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (reply.isOk()) {
            int dispatchId = reply.getSessionDispatchId();
            cc = new QueueConnectionConsumerImpl(this, dispatchId, this.requestRegistry, sessionPool, maxMessages);
            cc.setMyDispatchId(this.addRequestService(cc));
            ms = messageSelector;
            if (messageSelector != null && messageSelector.trim().length() == 0) {
                ms = null;
            }
        } else {
            throw ExceptionConverter.convert(reply.getException());
        }
        cc.createConsumer((QueueImpl)queue, ms);
        this.addConnectionConsumer(cc);
        return cc;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        String ms;
        this.verifyState();
        TopicConnectionConsumerImpl cc = null;
        CreateSessionReply reply = null;
        try {
            reply = (CreateSessionReply)this.requestRegistry.request(new CreateSessionRequest(0, false, 0, 1));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (reply.isOk()) {
            int dispatchId = reply.getSessionDispatchId();
            cc = new TopicConnectionConsumerImpl(this, dispatchId, this.requestRegistry, sessionPool, maxMessages);
            cc.setMyDispatchId(this.addRequestService(cc));
            ms = messageSelector;
            if (messageSelector != null && messageSelector.trim().length() == 0) {
                ms = null;
            }
        } else {
            throw ExceptionConverter.convert(reply.getException());
        }
        cc.createSubscriber((TopicImpl)topic, ms);
        this.addConnectionConsumer(cc);
        return cc;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.verifyState();
        TopicConnectionConsumerImpl cc = null;
        CreateSessionReply reply = null;
        try {
            reply = (CreateSessionReply)this.requestRegistry.request(new CreateSessionRequest(0, false, 0, 1));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        int dispatchId = reply.getSessionDispatchId();
        cc = new TopicConnectionConsumerImpl(this, dispatchId, this.requestRegistry, sessionPool, maxMessages);
        cc.setMyDispatchId(this.addRequestService(cc));
        cc.createDurableSubscriber((TopicImpl)topic, messageSelector, subscriptionName);
        this.addConnectionConsumer(cc);
        return cc;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("createConnectionConsumer, destination is null!");
        }
        DestinationImpl destImpl = (DestinationImpl)destination;
        ConnectionConsumer consumer = null;
        switch (destImpl.getType()) {
            case 0: 
            case 3: {
                consumer = this.createConnectionConsumer((Queue)destination, messageSelector, sessionPool, maxMessages);
                break;
            }
            case 1: 
            case 2: {
                consumer = this.createConnectionConsumer((Topic)destination, messageSelector, sessionPool, maxMessages);
            }
        }
        return consumer;
    }

    public String getClientID() throws JMSException {
        this.verifyState();
        return this.originalCID;
    }

    public void setClientID(String s) throws JMSException {
        this.verifyState();
        if (this.clientIdAdministratively) {
            throw new IllegalStateException("Client ID was set administratively and cannot be changed");
        }
        if (!this.clientIdAllowed) {
            throw new IllegalStateException("setClientID is only allowed immediatly after connection creation");
        }
        this.clientIdAllowed = false;
        try {
            SwiftUtilities.verifyClientId(s);
        }
        catch (Exception e) {
            throw new InvalidClientIDException(e.getMessage());
        }
        SetClientIdReply reply = null;
        try {
            reply = (SetClientIdReply)this.requestRegistry.request(new SetClientIdRequest(0, s));
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        this.clientID = reply.getClientId();
        this.originalCID = s;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.verifyState();
        return this.metaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.verifyState();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (listener != null) {
            this.verifyState();
        }
        this.exceptionListener = listener;
    }

    private void writeObject(Dumpable obj) throws Exception {
        Dumpalizer.dump(this.outStream, obj);
        this.outStream.flush();
    }

    @Override
    public void performRequest(Request request) {
        this.connectionQueue.enqueue(request);
    }

    @Override
    public void performReply(Reply reply) {
        this.connectionQueue.enqueue(reply);
    }

    @Override
    public void onException(IOException exception) {
        if (this.closed) {
            return;
        }
        this.cancel();
        if (this.exceptionListener != null) {
            this.exceptionListener.onException((JMSException)new ConnectionLostException(exception.getMessage()));
            this.exceptionListener = null;
        }
    }

    private void dispatchDumpable(Dumpable obj) {
        if (obj.getDumpId() != 151) {
            if (obj instanceof Reply) {
                this.requestRegistry.setReply((Reply)obj);
            } else if (obj instanceof Request) {
                Request req = (Request)obj;
                this.dispatch(req);
            }
        }
    }

    @Override
    public void dataAvailable(LengthCaptureDataInput in) {
        block7: {
            try {
                Dumpable obj = Dumpalizer.construct(in, this.dumpableFactory);
                if (obj == null) {
                    return;
                }
                if (obj.getDumpId() == 100) {
                    SMQPBulkRequest bulkRequest = (SMQPBulkRequest)obj;
                    for (int i = 0; i < bulkRequest.len; ++i) {
                        this.dispatchDumpable((Dumpable)bulkRequest.dumpables[i]);
                    }
                } else {
                    this.dispatchDumpable(obj);
                }
            }
            catch (Exception e) {
                if (this.closed) {
                    return;
                }
                this.cancel();
                if (this.exceptionListener == null) break block7;
                this.exceptionListener.onException((JMSException)new ConnectionLostException(e.getMessage()));
                this.exceptionListener = null;
            }
        }
    }

    public synchronized void start() throws JMSException {
        this.verifyState();
        this.clientIdAllowed = false;
        if (this.connectionState == 0) {
            int i;
            for (i = 0; i < this.sessionList.size(); ++i) {
                ((SessionImpl)this.sessionList.get(i)).startSession();
            }
            for (i = 0; i < this.connectionConsumerList.size(); ++i) {
                ((ConnectionConsumerImpl)this.connectionConsumerList.get(i)).startConsumer();
            }
            this.connectionState = 1;
        } else if (this.connectionState == -1) {
            throw new IllegalStateException("could not start - connection is disconnected!");
        }
    }

    public void stop() throws JMSException {
        this.verifyState();
        this.clientIdAllowed = false;
        if (this.connectionState == 1) {
            int i;
            for (i = 0; i < this.sessionList.size(); ++i) {
                ((SessionImpl)this.sessionList.get(i)).stopSession();
            }
            for (i = 0; i < this.connectionConsumerList.size(); ++i) {
                ((ConnectionConsumerImpl)this.connectionConsumerList.get(i)).stopConsumer();
            }
            this.connectionState = 0;
        } else if (this.connectionState == -1) {
            throw new IllegalStateException("could not stop - connection is disconnected!");
        }
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        if (this.connectionState == -1) {
            throw new IllegalStateException("could not close - connection is disconnected!");
        }
        try {
            TimerRegistry.Singleton().removeTimerListener(this.keepaliveInterval, (TimerListener)this);
            this.setExceptionListener(null);
            SessionImpl[] si = this.sessionList.toArray(new SessionImpl[this.sessionList.size()]);
            for (int i = 0; i < si.length; ++i) {
                SessionImpl session = si[i];
                if (session.isClosed()) continue;
                session.close();
            }
            ConnectionConsumerImpl[] ci = this.connectionConsumerList.toArray(new ConnectionConsumerImpl[this.connectionConsumerList.size()]);
            for (int i = 0; i < ci.length; ++i) {
                ConnectionConsumerImpl cc = ci[i];
                if (cc.isClosed()) continue;
                cc.close();
            }
            this.requestRegistry.request(new DisconnectRequest());
            this.closed = true;
            this.connectionQueue.stopQueue();
            this.connection.close();
            this.requestRegistry.cancelAllRequests(new TransportException("Connection closed"), false);
            this.sessionList.clear();
            this.connectionState = -1;
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
    }

    void cancel() {
        if (!this.cancelled) {
            int i;
            this.connectionQueue.stopQueue();
            this.cancelled = true;
            this.closed = true;
            for (i = 0; i < this.sessionList.size(); ++i) {
                SessionImpl session = (SessionImpl)this.sessionList.elementAt(i);
                session.cancel();
            }
            this.sessionList.clear();
            for (i = 0; i < this.connectionConsumerList.size(); ++i) {
                ConnectionConsumerImpl cc = (ConnectionConsumerImpl)this.connectionConsumerList.elementAt(i);
                cc.cancel();
            }
            this.connectionConsumerList.clear();
            TimerRegistry.Singleton().removeTimerListener(this.keepaliveInterval, (TimerListener)this);
            this.connection.close();
        }
        this.requestRegistry.cancelAllRequests(new TransportException("Connection closed"), false);
        this.connectionState = -1;
    }

    private class ConnectionTask
    implements AsyncTask {
        private ConnectionTask() {
        }

        @Override
        public boolean isValid() {
            return !ConnectionImpl.this.closed;
        }

        @Override
        public String getDispatchToken() {
            return ConnectionImpl.DISPATCH_TOKEN;
        }

        @Override
        public String getDescription() {
            return ConnectionImpl.this.myHostname + "/Connection/ConnectionTask";
        }

        @Override
        public void run() {
            if (!ConnectionImpl.this.closed && ConnectionImpl.this.connectionQueue.dequeue()) {
                ConnectionImpl.this.connectionPool.dispatchTask(this);
            }
        }

        @Override
        public void stop() {
        }
    }

    private class ConnectionQueue
    extends SingleProcessorQueue {
        SMQPBulkRequest bulkRequest;

        public ConnectionQueue() {
            super(100);
            this.bulkRequest = new SMQPBulkRequest();
        }

        @Override
        protected void startProcessor() {
            if (!ConnectionImpl.this.closed) {
                ConnectionImpl.this.connectionPool.dispatchTask(ConnectionImpl.this.connectionTask);
            }
        }

        @Override
        protected void process(Object[] bulk, int n) {
            try {
                if (n == 1) {
                    ConnectionImpl.this.writeObject((Dumpable)bulk[0]);
                } else {
                    this.bulkRequest.dumpables = bulk;
                    this.bulkRequest.len = n;
                    ConnectionImpl.this.writeObject(this.bulkRequest);
                }
            }
            catch (Exception e) {
                if (ConnectionImpl.this.exceptionListener != null) {
                    ConnectionImpl.this.exceptionListener.onException((JMSException)new ConnectionLostException(e.toString()));
                }
                ConnectionImpl.this.cancel();
            }
        }
    }
}

