/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v510;

import com.swiftmq.jms.DestinationImpl;
import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.MessageCloner;
import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.smqp.v510.CloseProducerRequest;
import com.swiftmq.jms.smqp.v510.ProduceMessageReply;
import com.swiftmq.jms.smqp.v510.ProduceMessageRequest;
import com.swiftmq.jms.v510.SessionImpl;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public class MessageProducerImpl
implements MessageProducer {
    private static final boolean ASYNC_SEND = Boolean.valueOf(System.getProperty("swiftmq.jms.persistent.asyncsend", "false"));
    boolean closed = false;
    int dispatchId = -1;
    int producerId = -1;
    RequestRegistry requestRegistry = null;
    String myHostname = null;
    SessionImpl mySession = null;
    boolean disableMessageId = false;
    boolean disableTimestamp = false;
    int deliveryMode;
    int priority;
    long timeToLive;
    int tsInc = 0;
    int nSend = 0;
    long currentDelay = 0L;
    int replyThreshold = 0;
    DestinationImpl destImpl = null;
    String clientId = null;
    DataByteArrayOutputStream dbos = new DataByteArrayOutputStream(2048);

    public MessageProducerImpl(SessionImpl mySession, int dispatchId, int producerId, RequestRegistry requestRegistry, String myHostname, String clientId) {
        this.mySession = mySession;
        this.dispatchId = dispatchId;
        this.producerId = producerId;
        this.requestRegistry = requestRegistry;
        this.myHostname = myHostname;
        this.clientId = clientId;
        this.replyThreshold = mySession.getMyConnection().getSmqpProducerReplyInterval();
        this.disableMessageId = !mySession.getMyConnection().isJmsMessageIdEnabled();
        this.disableTimestamp = !mySession.getMyConnection().isJmsMessageTimestampEnabled();
        this.deliveryMode = mySession.getMyConnection().getJmsDeliveryMode();
        this.priority = mySession.getMyConnection().getJmsPriority();
        this.timeToLive = mySession.getMyConnection().getJmsTTL();
    }

    protected void verifyState() throws JMSException {
        if (this.closed) {
            throw new JMSException("Message producer is closed");
        }
        this.mySession.verifyState();
    }

    Message initMessageForSend(Message message) throws JMSException {
        MessageImpl msg = null;
        msg = !(message instanceof MessageImpl) ? (MessageImpl)MessageCloner.cloneMessage(message) : (MessageImpl)message;
        msg.clearSwiftMQAllProps();
        msg.setReadOnly(false);
        msg.setStringProperty("JMSXUserID", this.mySession.getUserName());
        msg.setJMSDeliveryMode(this.deliveryMode);
        msg.setJMSPriority(this.priority);
        msg.setJMSExpiration(this.timeToLive == 0L ? this.timeToLive : System.currentTimeMillis() + this.timeToLive);
        if (!this.disableTimestamp) {
            msg.setJMSTimestamp(System.currentTimeMillis());
        }
        if (!this.disableMessageId) {
            msg.setJMSMessageID(this.myHostname + "-" + System.currentTimeMillis() + this.tsInc++);
            if (this.tsInc == Integer.MAX_VALUE) {
                this.tsInc = 0;
            }
        }
        return msg;
    }

    void processSend(int producerId, Message message) throws JMSException {
        boolean transacted = this.mySession.getTransacted();
        MessageImpl msg = (MessageImpl)message;
        if (transacted) {
            this.mySession.storeTransactedMessage(producerId, msg);
        } else {
            ++this.nSend;
            ProduceMessageReply reply = null;
            boolean replyRequired = this.nSend == this.replyThreshold || msg.getJMSDeliveryMode() == 2 && !ASYNC_SEND;
            try {
                ProduceMessageRequest request = null;
                if (!replyRequired) {
                    this.dbos.rewind();
                    msg.writeContent(this.dbos);
                    byte[] b = new byte[this.dbos.getCount()];
                    System.arraycopy(this.dbos.getBuffer(), 0, b, 0, b.length);
                    request = new ProduceMessageRequest(this.dispatchId, producerId, null, b);
                } else {
                    request = new ProduceMessageRequest(this.dispatchId, producerId, msg, null);
                }
                request.setReplyRequired(replyRequired);
                reply = (ProduceMessageReply)this.requestRegistry.request(request);
            }
            catch (Exception e) {
                throw ExceptionConverter.convert(e);
            }
            if (replyRequired) {
                if (reply == null) {
                    throw new JMSException("Request was cancelled (reply == null)");
                }
                this.nSend = 0;
                if (!reply.isOk()) {
                    throw ExceptionConverter.convert(reply.getException());
                }
                this.currentDelay = reply.getDelay();
                if (this.currentDelay > 0L) {
                    try {
                        Thread.sleep(this.currentDelay);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        msg.reset();
    }

    public void setDestinationImpl(Destination destImpl) {
        this.destImpl = (DestinationImpl)destImpl;
    }

    public Destination getDestination() throws JMSException {
        this.verifyState();
        return this.destImpl;
    }

    private boolean isTopicDestination() {
        return this.destImpl.getType() == 2 || this.destImpl.getType() == 1;
    }

    private boolean isTopicDestination(DestinationImpl dest) {
        return dest.getType() == 2 || dest.getType() == 1;
    }

    public void send(Message message) throws JMSException {
        this.verifyState();
        if (this.destImpl == null) {
            throw new UnsupportedOperationException("Cannot send unidentified on an unidentified MessageProducer!");
        }
        Message msg = this.initMessageForSend(message);
        msg.setJMSDestination((Destination)this.destImpl);
        if (this.isTopicDestination() && this.clientId != null) {
            msg.setStringProperty("JMS_SWIFTMQ_CID", this.clientId);
        }
        this.processSend(this.producerId, msg);
    }

    public void send(Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.verifyState();
        if (this.destImpl == null) {
            throw new UnsupportedOperationException("Cannot send unidentified on an unidentified MessageProducer!");
        }
        Message msg = this.initMessageForSend(message);
        msg.setJMSDeliveryMode(deliveryMode);
        msg.setJMSPriority(priority);
        msg.setJMSExpiration(ttl == 0L ? ttl : System.currentTimeMillis() + ttl);
        msg.setJMSDestination((Destination)this.destImpl);
        if (this.isTopicDestination() && this.clientId != null) {
            msg.setStringProperty("JMS_SWIFTMQ_CID", this.clientId);
        }
        this.processSend(this.producerId, msg);
    }

    public void send(Destination dest, Message message) throws JMSException {
        this.verifyState();
        if (this.destImpl != null) {
            throw new UnsupportedOperationException("This send method is only supported for unidentified MessageProducer!");
        }
        Message msg = this.initMessageForSend(message);
        msg.setJMSDestination(dest);
        if (this.isTopicDestination((DestinationImpl)dest) && this.clientId != null) {
            msg.setStringProperty("JMS_SWIFTMQ_CID", this.clientId);
        }
        this.processSend(-1, msg);
    }

    public void send(Destination dest, Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.verifyState();
        if (this.destImpl != null) {
            throw new UnsupportedOperationException("This send method is only supported for unidentified MessageProducer!");
        }
        Message msg = this.initMessageForSend(message);
        msg.setJMSDeliveryMode(deliveryMode);
        msg.setJMSPriority(priority);
        msg.setJMSExpiration(ttl == 0L ? ttl : System.currentTimeMillis() + ttl);
        msg.setJMSDestination(dest);
        if (this.isTopicDestination((DestinationImpl)dest) && this.clientId != null) {
            msg.setStringProperty("JMS_SWIFTMQ_CID", this.clientId);
        }
        this.processSend(-1, msg);
    }

    public boolean getDisableMessageID() throws JMSException {
        this.verifyState();
        return this.disableMessageId;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.verifyState();
        this.disableMessageId = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.verifyState();
        return this.disableTimestamp;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.verifyState();
        this.disableTimestamp = value;
    }

    public int getDeliveryMode() throws JMSException {
        this.verifyState();
        return this.deliveryMode;
    }

    public void setDeliveryMode(int dm) throws JMSException {
        this.verifyState();
        if (dm != 2 && dm != 1) {
            throw new JMSException("invalid delivery mode");
        }
        this.deliveryMode = dm;
    }

    public int getPriority() throws JMSException {
        this.verifyState();
        return this.priority;
    }

    public void setPriority(int prio) throws JMSException {
        this.verifyState();
        if (prio < 1 || prio > 9) {
            throw new JMSException("invalid priority, valid range is 1..9");
        }
        this.priority = prio;
    }

    public long getTimeToLive() throws JMSException {
        this.verifyState();
        return this.timeToLive;
    }

    public void setTimeToLive(long ttl) throws JMSException {
        this.verifyState();
        if (ttl < 0L) {
            throw new JMSException("invalid time to live");
        }
        this.timeToLive = ttl;
    }

    public void close() throws JMSException {
        if (this.closed || this.mySession.isClosed()) {
            return;
        }
        this.closed = true;
        if (this.producerId == -1) {
            return;
        }
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CloseProducerRequest(this.dispatchId, this.producerId));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
    }
}

