/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v600;

import com.swiftmq.client.thread.PoolManager;
import com.swiftmq.jms.smqp.v600.SMQPBulkRequest;
import com.swiftmq.jms.smqp.v600.SMQPFactory;
import com.swiftmq.jms.v600.Recreatable;
import com.swiftmq.jms.v600.RecreatableConnection;
import com.swiftmq.jms.v600.po.POAuthenticateRequest;
import com.swiftmq.jms.v600.po.POAuthenticateResponse;
import com.swiftmq.jms.v600.po.POClose;
import com.swiftmq.jms.v600.po.PODataAvailable;
import com.swiftmq.jms.v600.po.POException;
import com.swiftmq.jms.v600.po.POGetClientIdRequest;
import com.swiftmq.jms.v600.po.POHandover;
import com.swiftmq.jms.v600.po.POMetaDataRequest;
import com.swiftmq.jms.v600.po.POReconnect;
import com.swiftmq.jms.v600.po.PORecreate;
import com.swiftmq.jms.v600.po.POSetClientIdRequest;
import com.swiftmq.jms.v600.po.POTimeoutCheck;
import com.swiftmq.jms.v600.po.POVersionRequest;
import com.swiftmq.jms.v600.po.ReconnectVisitor;
import com.swiftmq.net.client.Connection;
import com.swiftmq.net.client.ExceptionHandler;
import com.swiftmq.net.client.InboundHandler;
import com.swiftmq.net.client.Reconnector;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.dump.DumpableFactory;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.tools.pipeline.POObject;
import com.swiftmq.tools.pipeline.PipelineQueue;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.timer.TimerEvent;
import com.swiftmq.tools.timer.TimerListener;
import com.swiftmq.tools.timer.TimerRegistry;
import com.swiftmq.tools.util.DataStreamOutputStream;
import com.swiftmq.tools.util.LengthCaptureDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class Connector
implements ReconnectVisitor,
InboundHandler,
ExceptionHandler {
    DumpableFactory dumpableFactory = new com.swiftmq.jms.smqp.SMQPFactory(new SMQPFactory());
    PipelineQueue pipelineQueue = new PipelineQueue(PoolManager.getInstance().getConnectionPool(), "Connector", this);
    Reconnector reconnector = null;
    RecreatableConnection recreatableConnection = null;
    boolean reconnectInProgress = false;
    boolean debug = false;
    Connection connection = null;
    DataStreamOutputStream outStream = null;
    boolean ok = false;
    Semaphore sem = null;
    Request current = null;
    long requestTime = -1L;
    volatile boolean recreateStarted = false;
    PORecreate currentRecreatePO = null;
    boolean closed = false;

    public Connector(Reconnector reconnector) {
        this.reconnector = reconnector;
        this.debug = reconnector.isDebug();
        if (this.debug) {
            System.out.println(this.toString() + ", created");
        }
    }

    public void dispatch(POObject po) {
        this.pipelineQueue.enqueue(po);
    }

    @Override
    public void dataAvailable(LengthCaptureDataInput in) {
        this.dispatch(new PODataAvailable(in));
    }

    @Override
    public void onException(IOException exception) {
        this.dispatch(new POException(exception));
    }

    private void writeObject(Dumpable obj) throws IOException {
        if (this.debug) {
            System.out.println(this.toString() + ", writeObject, obj=" + obj);
        }
        Dumpalizer.dump(this.outStream, obj);
        this.outStream.flush();
        this.requestTime = System.currentTimeMillis();
        TimerRegistry.Singleton().addInstantTimerListener(RequestRegistry.SWIFTMQ_REQUEST_TIMEOUT, new Timeout());
    }

    private void setReply(Dumpable obj) throws Exception {
        switch (this.current.getDumpId()) {
            case 0: {
                this.recreatableConnection.setVersionReply((Reply)obj);
                this.dispatch(new POAuthenticateRequest());
                break;
            }
            case 146: {
                this.recreatableConnection.setAuthenticateReply((Reply)obj);
                this.dispatch(new POAuthenticateResponse());
                break;
            }
            case 107: {
                this.recreatableConnection.setAuthenticateResponseReply((Reply)obj);
                this.dispatch(new POMetaDataRequest());
                break;
            }
            case 150: {
                this.recreatableConnection.setMetaDataReply((Reply)obj);
                this.dispatch(new POGetClientIdRequest());
                break;
            }
            case 148: {
                this.recreatableConnection.setGetClientIdReply((Reply)obj);
                this.dispatch(new POSetClientIdRequest());
                break;
            }
            case 162: {
                this.recreatableConnection.setSetClientIdReply((Reply)obj);
                new Recreator().start();
                break;
            }
        }
    }

    @Override
    public void visit(POReconnect po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (this.closed) {
            if (this.debug) {
                System.out.println(this.toString() + ", visit, po=" + po + ", closed, return");
            }
            if (po.getSemaphore() != null) {
                po.getSemaphore().notifySingleWaiter();
            }
            return;
        }
        if (this.reconnectInProgress && !po.isInternalRetry()) {
            if (this.debug) {
                System.out.println(this.toString() + ", visit, po=" + po + ", reconnect already in progress");
            }
            if (po.getSemaphore() != null) {
                po.getSemaphore().notifySingleWaiter();
            }
        } else {
            this.reconnectInProgress = true;
            this.recreateStarted = false;
            this.sem = po.getSemaphore();
            this.recreatableConnection = po.getRecreatableConnection();
            if (!po.isInternalRetry()) {
                this.recreatableConnection.prepareForReconnect();
            }
            this.connection = this.reconnector.getConnection();
            if (this.connection != null) {
                if (this.debug) {
                    System.out.println(this.toString() + ", visit, po=" + po + ", connection=" + this.connection);
                }
                this.connection.setInboundHandler(this);
                this.connection.setExceptionHandler(this);
                this.outStream = new DataStreamOutputStream(this.connection.getOutputStream());
                try {
                    this.connection.start();
                    this.dispatch(new POVersionRequest());
                }
                catch (Exception e) {
                    if (this.debug) {
                        System.out.println(this.toString() + ", visit, po=" + po + ", exception connection.start()=" + e);
                    }
                    this.reconnector.invalidateConnection();
                    this.connection = null;
                    this.dispatch(new POHandover());
                }
            } else {
                this.dispatch(new POHandover());
            }
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(PODataAvailable po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        DataInput in = po.getIn();
        try {
            Dumpable obj = Dumpalizer.construct(in, this.dumpableFactory);
            if (this.debug) {
                System.out.println(this.toString() + ", dataAvailable, obj=" + obj);
            }
            if (obj == null || obj.getDumpId() == 152) {
                return;
            }
            if (!this.recreateStarted) {
                if (obj.getDumpId() == 100) {
                    SMQPBulkRequest bulkRequest = (SMQPBulkRequest)obj;
                    for (int i = 0; i < bulkRequest.len; ++i) {
                        Dumpable dumpable = (Dumpable)bulkRequest.dumpables[i];
                        if (dumpable.getDumpId() == 152) continue;
                        this.setReply(dumpable);
                    }
                } else {
                    this.setReply(obj);
                }
                this.current = null;
            } else if (obj.getDumpId() == 100) {
                SMQPBulkRequest bulkRequest = (SMQPBulkRequest)obj;
                for (int i = 0; i < bulkRequest.len; ++i) {
                    Dumpable dumpable = (Dumpable)bulkRequest.dumpables[i];
                    if (dumpable.getDumpId() == 152) continue;
                    this.currentRecreatePO.getRecreatable().setRecreateReply((Reply)dumpable);
                    this.currentRecreatePO.setSuccess(true);
                    if (this.currentRecreatePO.getSemaphore() == null) continue;
                    this.currentRecreatePO.getSemaphore().notifySingleWaiter();
                }
            } else {
                this.currentRecreatePO.getRecreatable().setRecreateReply((Reply)obj);
                this.currentRecreatePO.setSuccess(true);
                if (this.currentRecreatePO.getSemaphore() != null) {
                    this.currentRecreatePO.getSemaphore().notifySingleWaiter();
                }
            }
            this.currentRecreatePO = null;
            this.requestTime = -1L;
        }
        catch (Exception e) {
            if (this.debug) {
                System.out.println(this.toString() + ", visit, po=" + po + ", exception=" + e);
            }
            if (this.currentRecreatePO != null) {
                this.currentRecreatePO.setSuccess(false);
                this.currentRecreatePO.setException(e.toString());
                if (this.currentRecreatePO.getSemaphore() != null) {
                    this.currentRecreatePO.getSemaphore().notifySingleWaiter();
                }
                this.currentRecreatePO = null;
            }
            this.reconnector.invalidateConnection();
            this.connection = null;
            this.reconnectInProgress = false;
            this.currentRecreatePO = null;
            this.requestTime = -1L;
            this.dispatch(new POReconnect(this.sem, this.recreatableConnection, true));
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POException po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (this.currentRecreatePO != null) {
            this.currentRecreatePO.setSuccess(false);
            this.currentRecreatePO.setException(po.getException());
            if (this.currentRecreatePO.getSemaphore() != null) {
                this.currentRecreatePO.getSemaphore().notifySingleWaiter();
            }
            this.currentRecreatePO = null;
        }
        this.reconnector.invalidateConnection();
        this.connection = null;
        this.reconnectInProgress = false;
        this.requestTime = -1L;
        this.dispatch(new POReconnect(this.sem, this.recreatableConnection, true));
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POTimeoutCheck po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (this.closed) {
            return;
        }
        if (this.requestTime != -1L && System.currentTimeMillis() - this.requestTime > RequestRegistry.SWIFTMQ_REQUEST_TIMEOUT) {
            if (this.debug) {
                System.out.println(this.toString() + ", visit, po=" + po + ", timeout detected!");
            }
            if (this.currentRecreatePO != null) {
                this.currentRecreatePO.setSuccess(false);
                this.currentRecreatePO.setException("Timeout detected");
                this.currentRecreatePO.getSemaphore().notifySingleWaiter();
                this.currentRecreatePO = null;
            }
            this.reconnector.invalidateConnection();
            this.connection = null;
            this.reconnectInProgress = false;
            this.requestTime = -1L;
            this.dispatch(new POReconnect(this.sem, this.recreatableConnection, true));
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POVersionRequest po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (this.closed) {
            return;
        }
        this.current = this.recreatableConnection.getVersionRequest();
        try {
            this.writeObject(this.current);
        }
        catch (IOException e) {
            if (this.debug) {
                System.out.println(this.toString() + ", visit, po=" + po + ", writeObject=" + e);
            }
            this.reconnector.invalidateConnection();
            this.connection = null;
            this.reconnectInProgress = false;
            this.dispatch(new POReconnect(this.sem, this.recreatableConnection, true));
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POAuthenticateRequest po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (this.closed) {
            return;
        }
        this.current = this.recreatableConnection.getAuthenticateRequest();
        try {
            this.writeObject(this.current);
        }
        catch (IOException e) {
            this.reconnector.invalidateConnection();
            this.connection = null;
            this.reconnectInProgress = false;
            this.dispatch(new POReconnect(this.sem, this.recreatableConnection, true));
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POAuthenticateResponse po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (this.closed) {
            return;
        }
        this.current = this.recreatableConnection.getAuthenticateResponse();
        try {
            this.writeObject(this.current);
        }
        catch (IOException e) {
            if (this.debug) {
                System.out.println(this.toString() + ", visit, po=" + po + ", writeObject=" + e);
            }
            this.reconnector.invalidateConnection();
            this.connection = null;
            this.reconnectInProgress = false;
            this.dispatch(new POReconnect(this.sem, this.recreatableConnection, true));
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POMetaDataRequest po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (this.closed) {
            return;
        }
        this.current = this.recreatableConnection.getMetaDataRequest();
        try {
            this.writeObject(this.current);
        }
        catch (IOException e) {
            if (this.debug) {
                System.out.println(this.toString() + ", visit, po=" + po + ", writeObject=" + e);
            }
            this.reconnector.invalidateConnection();
            this.connection = null;
            this.reconnectInProgress = false;
            this.dispatch(new POReconnect(this.sem, this.recreatableConnection, true));
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POGetClientIdRequest po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (this.closed) {
            return;
        }
        this.current = this.recreatableConnection.getGetClientIdRequest();
        if (this.current != null) {
            try {
                this.writeObject(this.current);
            }
            catch (IOException e) {
                if (this.debug) {
                    System.out.println(this.toString() + ", visit, po=" + po + ", writeObject=" + e);
                }
                this.reconnector.invalidateConnection();
                this.connection = null;
                this.reconnectInProgress = false;
                this.dispatch(new POReconnect(this.sem, this.recreatableConnection, true));
            }
        } else {
            new Recreator().start();
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POSetClientIdRequest po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (this.closed) {
            return;
        }
        this.current = this.recreatableConnection.getSetClientIdRequest();
        if (this.current != null) {
            try {
                this.writeObject(this.current);
            }
            catch (IOException e) {
                if (this.debug) {
                    System.out.println(this.toString() + ", visit, po=" + po + ", writeObject=" + e);
                }
                this.reconnector.invalidateConnection();
                this.connection = null;
                this.reconnectInProgress = false;
                this.dispatch(new POReconnect(this.sem, this.recreatableConnection, true));
            }
        } else {
            new Recreator().start();
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(PORecreate po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (this.closed) {
            return;
        }
        this.currentRecreatePO = po;
        try {
            this.writeObject(po.getRequest());
        }
        catch (IOException e) {
            if (this.debug) {
                System.out.println(this.toString() + ", visit, po=" + po + ", writeObject=" + e);
            }
            po.setSuccess(false);
            po.getSemaphore().notifySingleWaiter();
            this.reconnector.invalidateConnection();
            this.connection = null;
            this.reconnectInProgress = false;
            this.dispatch(new POReconnect(this.sem, this.recreatableConnection, true));
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POHandover po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        if (!this.closed) {
            if (this.connection != null || this.sem != null) {
                this.recreatableConnection.handOver(this.connection);
            } else {
                this.recreatableConnection.cancelAndNotify(new Exception("Unable to connect to " + this.reconnector.getServers() + ", max. retries reached!"), false);
                this.dispatch(new POClose(null));
            }
        }
        this.reconnectInProgress = false;
        if (this.sem != null) {
            this.sem.notifySingleWaiter();
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POClose po) {
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " ...");
        }
        this.closed = true;
        if (this.reconnectInProgress && this.sem != null) {
            this.sem.notifySingleWaiter();
        }
        this.pipelineQueue.close();
        if (po.getSemaphore() != null) {
            po.getSemaphore().notifySingleWaiter();
        }
        if (this.debug) {
            System.out.println(this.toString() + ", visit, po=" + po + " done");
        }
    }

    public void close() {
        if (this.debug) {
            System.out.println(this.toString() + ", close ...");
        }
        Semaphore sem = new Semaphore();
        this.dispatch(new POClose(sem));
        sem.waitHere();
        if (this.debug) {
            System.out.println(this.toString() + ", close done");
        }
    }

    public String toString() {
        return new Date() + " [Connector, reconnector=" + this.reconnector + "]";
    }

    private class Timeout
    implements TimerListener {
        private Timeout() {
        }

        @Override
        public void performTimeAction(TimerEvent evt) {
            if (Connector.this.debug) {
                System.out.println(new Date() + "/" + evt);
            }
            Connector.this.dispatch(new POTimeoutCheck());
        }
    }

    private class Recreator
    extends Thread {
        private Recreator() {
        }

        private boolean recreate(Recreatable recreatable) {
            List list;
            if (Connector.this.closed) {
                return false;
            }
            Request request = recreatable.getRecreateRequest();
            if (request != null) {
                Semaphore sem = new Semaphore();
                PORecreate po = new PORecreate(sem, recreatable, request);
                Connector.this.dispatch(po);
                sem.waitHere();
                if (!po.isSuccess()) {
                    return false;
                }
            }
            if ((list = recreatable.getRecreatables()) != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    if (this.recreate((Recreatable)list.get(i))) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public void run() {
            if (Connector.this.debug) {
                System.out.println(Connector.this.toString() + "/Recreator, started");
            }
            Connector.this.recreateStarted = true;
            boolean b = this.recreate(Connector.this.recreatableConnection);
            Connector.this.recreateStarted = false;
            if (b) {
                Connector.this.dispatch(new POHandover());
            }
            if (Connector.this.debug) {
                System.out.println(Connector.this.toString() + "/Recreator, stopped");
            }
        }
    }
}

