/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v600;

import com.swiftmq.jms.DestinationImpl;
import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.MessageCloner;
import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.smqp.v600.CloseProducerRequest;
import com.swiftmq.jms.smqp.v600.ProduceMessageReply;
import com.swiftmq.jms.smqp.v600.ProduceMessageRequest;
import com.swiftmq.jms.smqp.v600.SMQPUtil;
import com.swiftmq.jms.v600.SessionImpl;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.ValidationException;
import com.swiftmq.tools.tracking.MessageTracker;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import com.swiftmq.tools.util.IdGenerator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;

public class MessageProducerImpl
implements MessageProducer,
RequestRetryValidator {
    private static final boolean ASYNC_SEND = Boolean.valueOf(System.getProperty("swiftmq.jms.persistent.asyncsend", "false"));
    public volatile int producerId = -1;
    boolean closed = false;
    RequestRegistry requestRegistry = null;
    String myHostname = null;
    SessionImpl mySession = null;
    boolean disableMessageId = false;
    boolean disableTimestamp = false;
    int deliveryMode;
    int priority;
    long timeToLive;
    int tsInc = 0;
    int nSend = 0;
    long currentDelay = 0L;
    int replyThreshold = 0;
    String uniqueProducerId = IdGenerator.getInstance().nextId('/');
    DestinationImpl destImpl = null;
    String clientId = null;
    DataByteArrayOutputStream dbos = new DataByteArrayOutputStream(2048);

    public MessageProducerImpl(SessionImpl mySession, int producerId, RequestRegistry requestRegistry, String myHostname, String clientId) {
        this.mySession = mySession;
        this.producerId = producerId;
        this.requestRegistry = requestRegistry;
        this.myHostname = myHostname;
        this.clientId = clientId;
        this.replyThreshold = mySession.getMyConnection().getSmqpProducerReplyInterval();
        this.disableMessageId = !mySession.getMyConnection().isJmsMessageIdEnabled();
        this.disableTimestamp = !mySession.getMyConnection().isJmsMessageTimestampEnabled();
        this.deliveryMode = mySession.getMyConnection().getJmsDeliveryMode();
        this.priority = mySession.getMyConnection().getJmsPriority();
        this.timeToLive = mySession.getMyConnection().getJmsTTL();
    }

    @Override
    public void validate(Request request) throws ValidationException {
        if (request instanceof ProduceMessageRequest) {
            try {
                ProduceMessageRequest r = (ProduceMessageRequest)request;
                r.setDispatchId(this.mySession.dispatchId);
                r.setQueueProducerId(this.producerId);
                MessageImpl msg = SMQPUtil.getMessage(r);
                Destination dest = msg.getJMSDestination();
                if (dest instanceof TemporaryQueue || dest instanceof TemporaryTopic) {
                    r.setCancelledByValidator(true);
                    return;
                }
                msg.setBooleanProperty("JMS_SWIFTMQ_DOUBT_DUPLICATE", true);
                if (r.getSingleMessage() != null) {
                    r.setSingleMessage(msg);
                }
                r.setMessageCopy(SMQPUtil.toBytes(msg));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ValidationException(e.toString());
            }
        } else {
            CloseProducerRequest r = (CloseProducerRequest)request;
            r.setDispatchId(this.mySession.dispatchId);
            r.setQueueProducerId(this.producerId);
        }
    }

    protected void verifyState() throws JMSException {
        if (this.closed) {
            throw new JMSException("Message producer is closed");
        }
        this.mySession.verifyState();
    }

    private String nextId() {
        StringBuffer b = new StringBuffer(this.myHostname);
        b.append('/');
        b.append(this.uniqueProducerId);
        b.append('/');
        b.append(this.tsInc++);
        if (this.tsInc == Integer.MAX_VALUE) {
            this.tsInc = 0;
        }
        return b.toString();
    }

    Message initMessageForSend(Message message) throws JMSException {
        MessageImpl msg = null;
        msg = this.mySession.withinOnMessage || !(message instanceof MessageImpl) ? (MessageImpl)MessageCloner.cloneMessage(message) : (MessageImpl)message;
        msg.clearSwiftMQAllProps();
        msg.setReadOnly(false);
        msg.removeProperty("JMS_SWIFTMQ_DOUBT_DUPLICATE");
        msg.setStringProperty("JMSXUserID", this.mySession.getUserName());
        msg.setJMSDeliveryMode(this.deliveryMode);
        msg.setJMSPriority(this.priority);
        msg.setJMSExpiration(this.timeToLive == 0L ? this.timeToLive : System.currentTimeMillis() + this.timeToLive);
        if (!this.disableTimestamp) {
            msg.setJMSTimestamp(System.currentTimeMillis());
        }
        if (!this.disableMessageId) {
            msg.setJMSMessageID(this.nextId());
        }
        return msg;
    }

    void processSend(int producerId, Message message) throws JMSException {
        boolean transacted = this.mySession.getTransacted();
        MessageImpl msg = (MessageImpl)message;
        if (transacted) {
            if (MessageTracker.enabled) {
                MessageTracker.getInstance().track(msg, new String[]{this.mySession.myConnection.toString(), this.mySession.toString(), this.toString()}, "processSend, storeTransactedMessage");
            }
            this.mySession.storeTransactedMessage(this, msg);
        } else {
            ++this.nSend;
            ProduceMessageReply reply = null;
            boolean replyRequired = this.nSend == this.replyThreshold || msg.getJMSDeliveryMode() == 2 && !ASYNC_SEND;
            try {
                ProduceMessageRequest request = null;
                if (!replyRequired) {
                    this.dbos.rewind();
                    msg.writeContent(this.dbos);
                    byte[] b = new byte[this.dbos.getCount()];
                    System.arraycopy(this.dbos.getBuffer(), 0, b, 0, b.length);
                    request = new ProduceMessageRequest(this, this.mySession.dispatchId, producerId, null, b);
                } else {
                    request = new ProduceMessageRequest(this, this.mySession.dispatchId, producerId, msg, null);
                }
                request.setReplyRequired(replyRequired);
                if (MessageTracker.enabled) {
                    MessageTracker.getInstance().track(msg, new String[]{this.mySession.myConnection.toString(), this.mySession.toString(), this.toString()}, "processSend ...");
                }
                reply = (ProduceMessageReply)this.requestRegistry.request(request);
                if (MessageTracker.enabled) {
                    MessageTracker.getInstance().track(msg, new String[]{this.mySession.myConnection.toString(), this.mySession.toString(), this.toString()}, "processSend done, reply=" + reply);
                }
            }
            catch (Exception e) {
                if (MessageTracker.enabled) {
                    MessageTracker.getInstance().track(msg, new String[]{this.mySession.myConnection.toString(), this.mySession.toString(), this.toString()}, "processSend, exception=" + e);
                }
                e.printStackTrace();
                throw ExceptionConverter.convert(e);
            }
            if (replyRequired) {
                if (reply == null) {
                    throw new JMSException("Request was cancelled (reply == null)");
                }
                this.nSend = 0;
                if (!reply.isOk()) {
                    throw ExceptionConverter.convert(reply.getException());
                }
                this.currentDelay = reply.getDelay();
                if (this.currentDelay > 0L) {
                    try {
                        Thread.sleep(this.currentDelay);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        msg.reset();
    }

    public void setDestinationImpl(Destination destImpl) {
        this.destImpl = (DestinationImpl)destImpl;
    }

    public Destination getDestination() throws JMSException {
        this.verifyState();
        return this.destImpl;
    }

    private boolean isTopicDestination() {
        return this.destImpl.getType() == 2 || this.destImpl.getType() == 1;
    }

    private boolean isTopicDestination(DestinationImpl dest) {
        return dest.getType() == 2 || dest.getType() == 1;
    }

    public void send(Message message) throws JMSException {
        this.verifyState();
        if (this.destImpl == null) {
            throw new UnsupportedOperationException("Cannot send unidentified on an unidentified MessageProducer!");
        }
        Message msg = this.initMessageForSend(message);
        msg.setJMSDestination((Destination)this.destImpl);
        if (this.isTopicDestination() && this.clientId != null) {
            msg.setStringProperty("JMS_SWIFTMQ_CID", this.clientId);
        }
        this.processSend(this.producerId, msg);
    }

    public void send(Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.verifyState();
        if (this.destImpl == null) {
            throw new UnsupportedOperationException("Cannot send unidentified on an unidentified MessageProducer!");
        }
        Message msg = this.initMessageForSend(message);
        msg.setJMSDeliveryMode(deliveryMode);
        msg.setJMSPriority(priority);
        msg.setJMSExpiration(ttl == 0L ? ttl : System.currentTimeMillis() + ttl);
        msg.setJMSDestination((Destination)this.destImpl);
        if (this.isTopicDestination() && this.clientId != null) {
            msg.setStringProperty("JMS_SWIFTMQ_CID", this.clientId);
        }
        this.processSend(this.producerId, msg);
    }

    public void send(Destination dest, Message message) throws JMSException {
        this.verifyState();
        if (this.destImpl != null) {
            throw new UnsupportedOperationException("This send method is only supported for unidentified MessageProducer!");
        }
        Message msg = this.initMessageForSend(message);
        msg.setJMSDestination(dest);
        if (this.isTopicDestination((DestinationImpl)dest) && this.clientId != null) {
            msg.setStringProperty("JMS_SWIFTMQ_CID", this.clientId);
        }
        this.processSend(-1, msg);
    }

    public void send(Destination dest, Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.verifyState();
        if (this.destImpl != null) {
            throw new UnsupportedOperationException("This send method is only supported for unidentified MessageProducer!");
        }
        Message msg = this.initMessageForSend(message);
        msg.setJMSDeliveryMode(deliveryMode);
        msg.setJMSPriority(priority);
        msg.setJMSExpiration(ttl == 0L ? ttl : System.currentTimeMillis() + ttl);
        msg.setJMSDestination(dest);
        if (this.isTopicDestination((DestinationImpl)dest) && this.clientId != null) {
            msg.setStringProperty("JMS_SWIFTMQ_CID", this.clientId);
        }
        this.processSend(-1, msg);
    }

    public boolean getDisableMessageID() throws JMSException {
        this.verifyState();
        return this.disableMessageId;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.verifyState();
        this.disableMessageId = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.verifyState();
        return this.disableTimestamp;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.verifyState();
        this.disableTimestamp = value;
    }

    public int getDeliveryMode() throws JMSException {
        this.verifyState();
        return this.deliveryMode;
    }

    public void setDeliveryMode(int dm) throws JMSException {
        this.verifyState();
        if (dm != 2 && dm != 1) {
            throw new JMSException("invalid delivery mode");
        }
        this.deliveryMode = dm;
    }

    public int getPriority() throws JMSException {
        this.verifyState();
        return this.priority;
    }

    public void setPriority(int prio) throws JMSException {
        this.verifyState();
        if (prio < 1 || prio > 9) {
            throw new JMSException("invalid priority, valid range is 1..9");
        }
        this.priority = prio;
    }

    public long getTimeToLive() throws JMSException {
        this.verifyState();
        return this.timeToLive;
    }

    public void setTimeToLive(long ttl) throws JMSException {
        this.verifyState();
        if (ttl < 0L) {
            throw new JMSException("invalid time to live");
        }
        this.timeToLive = ttl;
    }

    void _close(boolean delayClose) throws JMSException {
        if (this.closed || this.mySession.isClosed()) {
            return;
        }
        if (delayClose && this.mySession.transacted) {
            this.mySession.delayClose(this);
            return;
        }
        this.closed = true;
        if (this.producerId == -1) {
            return;
        }
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CloseProducerRequest(this, this.mySession.dispatchId, this.producerId));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        this.mySession.removeMessageProducerImpl(this);
    }

    public void close() throws JMSException {
        this._close(true);
    }
}

